/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.loader;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import xdoclet.loader.XDocletModule;

class XDocletXmlParser
extends DefaultHandler {
    private final SAXParserFactory _factory = SAXParserFactory.newInstance();
    private XDocletModule module;

    public XDocletXmlParser() {
        this._factory.setValidating(false);
    }

    public XDocletModule parse(InputStream in) {
        try {
            SAXParser parser = this._factory.newSAXParser();
            parser.parse(in, (DefaultHandler)this);
        }
        catch (IOException e) {
            this.module = null;
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            this.module = null;
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            this.module = null;
            e.printStackTrace();
        }
        catch (SAXException e) {
            this.module = null;
            e.printStackTrace();
        }
        return this.module;
    }

    public void startDocument() {
        this.module = new XDocletModule();
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes attributes) {
        if (qName.equals("taghandler")) {
            this.module.addTagHandler(attributes.getValue("namespace"), attributes.getValue("class"));
        } else if (qName.equals("subtask")) {
            this.module.addSubTask(attributes.getValue("name"), attributes.getValue("implementation-class"), attributes.getValue("parent-task-class"));
        }
    }
}

