/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.expr;

import java.util.List;
import org.jaxen.Context;
import org.jaxen.JaxenException;
import org.jaxen.Navigator;
import org.jaxen.expr.DefaultTruthExpr;
import org.jaxen.expr.Expr;
import org.jaxen.function.BooleanFunction;
import org.jaxen.function.NumberFunction;
import org.jaxen.function.StringFunction;

abstract class DefaultEqualityExpr
extends DefaultTruthExpr {
    public DefaultEqualityExpr(Expr lhs, Expr rhs) {
        super(lhs, rhs);
    }

    public Object evaluate(Context context) throws JaxenException {
        Object lhsValue = this.getLHS().evaluate(context);
        Object rhsValue = this.getRHS().evaluate(context);
        Navigator nav = context.getNavigator();
        if (this.bothAreSets(lhsValue, rhsValue)) {
            return this.evaluateSetSet((List)lhsValue, (List)rhsValue, nav);
        }
        if (this.eitherIsSet(lhsValue, rhsValue)) {
            List theSet = null;
            Object theOther = null;
            if (this.isSet(lhsValue)) {
                theSet = (List)lhsValue;
                theOther = rhsValue;
            } else {
                theSet = (List)rhsValue;
                theOther = lhsValue;
            }
            if (this.isNumber(theOther)) {
                return this.evaluateSetNumber(theSet, (Number)theOther, nav);
            }
            if (this.isBoolean(theOther)) {
                return this.evaluateSetBoolean(theSet, (Boolean)theOther, nav);
            }
            if (this.isString(theOther)) {
                return this.evaluateSetString(theSet, (String)theOther, nav);
            }
        }
        if (this.eitherIsBoolean(lhsValue, rhsValue)) {
            return this.evaluateObjectObject(BooleanFunction.evaluate(lhsValue), BooleanFunction.evaluate(rhsValue));
        }
        if (this.eitherIsNumber(lhsValue, rhsValue)) {
            return this.evaluateObjectObject(NumberFunction.evaluate(lhsValue, nav), NumberFunction.evaluate(rhsValue, nav));
        }
        return this.evaluateObjectObject(StringFunction.evaluate(lhsValue, nav), StringFunction.evaluate(rhsValue, nav));
    }

    protected abstract Object evaluateObjectObject(Object var1, Object var2);

    protected abstract Object evaluateSetBoolean(List var1, Boolean var2, Navigator var3);

    protected abstract Object evaluateSetNumber(List var1, Number var2, Navigator var3);

    protected abstract Object evaluateSetSet(List var1, List var2, Navigator var3);

    protected abstract Object evaluateSetString(List var1, String var2, Navigator var3);

    public String toString() {
        return "[(DefaultEqualityExpr): " + this.getLHS() + ", " + this.getRHS() + "]";
    }
}

