/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.property;

import org.apache.avalon.excalibur.property.PropertyException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Resolvable;

public final class PropertyUtil {
    public static Object resolveProperty(String property, Context context, boolean ignoreUndefined) throws PropertyException {
        int start = property.indexOf("${");
        if (-1 == start) {
            return property;
        }
        int end = property.indexOf(125, start);
        if (-1 == end) {
            return property;
        }
        int length = property.length();
        if (start == 0 && end == length - 1) {
            return PropertyUtil.resolveValue(property.substring(start + 2, end), context, ignoreUndefined);
        }
        StringBuffer sb = new StringBuffer();
        int lastPlace = 0;
        do {
            Object value = PropertyUtil.resolveValue(property.substring(start + 2, end), context, ignoreUndefined);
            sb.append(property.substring(lastPlace, start));
            sb.append(value);
            lastPlace = end + 1;
        } while (-1 != (start = property.indexOf("${", end)) && -1 != (end = property.indexOf(125, start)));
        sb.append(property.substring(lastPlace, length));
        return sb.toString();
    }

    private static Object resolveValue(String key, Context context, boolean ignoreUndefined) throws PropertyException {
        Object value = null;
        try {
            value = context.get((Object)key);
            while (value != null && value instanceof Resolvable) {
                value = ((Resolvable)value).resolve(context);
            }
        }
        catch (ContextException ce) {
            // empty catch block
        }
        if (value == null) {
            if (ignoreUndefined) {
                return "";
            }
            throw new PropertyException("Unable to find " + key + " to expand during " + "property resolution.");
        }
        return value;
    }

    private PropertyUtil() {
    }
}

