/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.component;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.excalibur.component.ComponentHandler;
import org.apache.avalon.excalibur.component.DefaultRoleManager;
import org.apache.avalon.excalibur.component.RoleManager;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLoggable;

public class ExcaliburComponentManager
extends AbstractLoggable
implements ComponentManager,
Configurable,
Contextualizable,
Disposable {
    private final ClassLoader m_loader;
    private Context m_context;
    private Map m_componentMapping;
    private Map m_componentHandlers;
    private RoleManager m_roles;
    private boolean m_disposed;

    public void contextualize(Context context) {
        if (this.m_context == null) {
            this.m_context = context;
        }
    }

    public void dispose() {
        ExcaliburComponentManager excaliburComponentManager = this;
        synchronized (excaliburComponentManager) {
            this.m_disposed = true;
            Iterator<Object> keys = this.m_componentHandlers.keySet().iterator();
            ArrayList keyList = new ArrayList();
            while (keys.hasNext()) {
                Object key = keys.next();
                ComponentHandler handler = (ComponentHandler)((Object)this.m_componentHandlers.get(key));
                try {
                    handler.dispose();
                }
                catch (Exception e) {
                    this.getLogger().debug("Caught an exception trying to dispose of the component handler.", (Throwable)e);
                }
                keyList.add(key);
            }
            keys = keyList.iterator();
            while (keys.hasNext()) {
                this.m_componentHandlers.remove(keys.next());
            }
            keyList.clear();
        }
    }

    public Component lookup(String role) throws ComponentException {
        if (this.m_disposed) {
            throw new IllegalStateException("You cannot lookup components on a disposed ComponentManager");
        }
        if (role == null) {
            String message = "ComponentManager Attempted to retrieve component with null role.";
            this.getLogger().error("ComponentManager Attempted to retrieve component with null role.");
            throw new ComponentException("ComponentManager Attempted to retrieve component with null role.");
        }
        ComponentHandler handler = (ComponentHandler)((Object)this.m_componentHandlers.get(role));
        if (handler == null) {
            this.getLogger().debug("Could not find ComponentHandler, attempting to create one for role: " + role);
            try {
                String className = this.m_roles.getDefaultClassNameForRole(role);
                Class<?> componentClass = this.m_loader.loadClass(className);
                DefaultConfiguration configuration = new DefaultConfiguration("", "-");
                handler = ComponentHandler.getComponentHandler(componentClass, (Configuration)configuration, this, this.m_context, this.m_roles);
                handler.setLogger(this.getLogger());
                handler.initialize();
            }
            catch (Exception e) {
                String message = "ComponentManager Could not find component for role: " + role;
                this.getLogger().error(message, (Throwable)e);
                throw new ComponentException(message, (Throwable)e);
            }
            this.m_componentHandlers.put(role, handler);
        }
        Component component = null;
        try {
            component = handler.get();
        }
        catch (IllegalStateException ise) {
            try {
                handler.initialize();
                component = handler.get();
            }
            catch (Exception e) {
                String message = "Could not access the Component for role: " + role;
                this.getLogger().debug(message, (Throwable)e);
                throw new ComponentException(message, (Throwable)e);
            }
        }
        catch (Exception e) {
            String message = "Could not access the Component for role: " + role;
            this.getLogger().debug(message, (Throwable)e);
            throw new ComponentException(message, (Throwable)e);
        }
        this.m_componentMapping.put(component, handler);
        return component;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        if (this.m_roles == null) {
            DefaultRoleManager role_info = new DefaultRoleManager();
            role_info.setLogger(this.getLogger());
            role_info.configure(configuration);
            this.m_roles = role_info;
        }
        Configuration[] configurations = configuration.getChildren();
        int i = 0;
        while (i < configurations.length) {
            String type = configurations[i].getName();
            if (!type.equals("role")) {
                String role = configurations[i].getAttribute("role", "");
                String className = configurations[i].getAttribute("class", "");
                if (role.equals("")) {
                    role = this.m_roles.getRoleForName(type);
                }
                if (role != null && !role.equals("")) {
                    if (className.equals("")) {
                        className = this.m_roles.getDefaultClassNameForRole(role);
                    }
                    try {
                        this.getLogger().debug("Adding component (" + role + " = " + className + ")");
                        Class<?> clazz = this.m_loader.loadClass(className);
                        this.addComponent(role, clazz, configurations[i]);
                    }
                    catch (Exception e) {
                        String message = "Could not get class " + className + " for role " + role + " on configuration element " + configurations[i].getName();
                        this.getLogger().error(message, (Throwable)e);
                        throw new ConfigurationException(message, (Throwable)e);
                    }
                }
            }
            ++i;
        }
    }

    public void setRoleManager(RoleManager roles) {
        if (this.m_roles == null) {
            this.m_roles = roles;
        }
    }

    public void release(Component component) {
        if (component == null) {
            return;
        }
        ComponentHandler handler = (ComponentHandler)((Object)this.m_componentMapping.get(component));
        if (handler != null) {
            try {
                handler.put(component);
            }
            catch (Exception e) {
                this.getLogger().debug("Error trying to release component.", (Throwable)e);
            }
            this.m_componentMapping.remove(component);
        }
    }

    public void addComponent(String role, Class component, Configuration configuration) throws ComponentException {
        try {
            this.getLogger().debug("Attempting to get Handler for: " + role);
            ComponentHandler handler = ComponentHandler.getComponentHandler(component, configuration, this, this.m_context, this.m_roles);
            this.getLogger().debug("Handler type = " + ((Object)((Object)handler)).getClass().getName());
            handler.setLogger(this.getLogger());
            this.m_componentHandlers.put(role, handler);
        }
        catch (Exception e) {
            throw new ComponentException("Could not set up Component for role: " + role, (Throwable)e);
        }
    }

    public void addComponentInstance(String role, Object instance) {
        try {
            ComponentHandler handler = ComponentHandler.getComponentHandler((Component)instance);
            handler.setLogger(this.getLogger());
            this.m_componentHandlers.put(role, handler);
        }
        catch (Exception e) {
            this.getLogger().warn("Could not set up Component for role: " + role, (Throwable)e);
        }
    }

    public ExcaliburComponentManager() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public ExcaliburComponentManager(ClassLoader loader) {
        this.m_loader = loader == null ? Thread.currentThread().getContextClassLoader() : loader;
        this.m_componentHandlers = Collections.synchronizedMap(new HashMap());
        this.m_componentMapping = Collections.synchronizedMap(new HashMap());
    }
}

