/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.camelot;

import org.apache.avalon.Configuration;
import org.apache.avalon.camelot.Application;
import org.apache.avalon.camelot.ApplicationState;
import org.apache.avalon.camelot.Container;
import org.apache.avalon.camelot.Factory;
import org.apache.avalon.camelot.Registry;

public abstract class AbstractApplication
implements Application {
    protected ApplicationState m_state = ApplicationState.CREATED;
    protected Factory m_factory;
    protected Container m_container;
    protected Registry m_registry;

    public void configure(Configuration configuration) {
        this.m_state = ApplicationState.CONFIGURED;
    }

    public void init() throws Exception {
        this.m_state = ApplicationState.INITIALIZED;
        this.m_factory = this.createFactory();
        this.m_container = this.createContainer();
        this.m_registry = this.createRegistry();
    }

    protected abstract Factory createFactory() throws Exception;

    protected abstract Container createContainer() throws Exception;

    protected abstract Registry createRegistry() throws Exception;

    public void dispose() throws Exception {
        this.m_state = ApplicationState.DISPOSED;
        this.m_factory = null;
        this.m_container = null;
        this.m_registry = null;
    }

    public void stop() {
        this.m_state = ApplicationState.STOPPED;
    }

    public ApplicationState getState() {
        return this.m_state;
    }

    public Factory getFactory() {
        return this.m_factory;
    }

    public Container getContainer() {
        return this.m_container;
    }

    public Registry getRegistry() {
        return this.m_registry;
    }
}

