/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.avalon.excalibur.io.IOUtil;

public final class FileUtil {
    public static File toFile(URL url) {
        if (!url.getProtocol().equals("file")) {
            return null;
        }
        String filename = url.getFile().replace('/', File.separatorChar);
        return new File(filename);
    }

    public static String removeExtention(String filename) {
        return FileUtil.removeExtension(filename);
    }

    public static String removeExtension(String filename) {
        int index = filename.lastIndexOf(46);
        if (-1 == index) {
            return filename;
        }
        return filename.substring(0, index);
    }

    public static String removePath(String filepath) {
        int index = filepath.lastIndexOf(File.separator);
        if (-1 == index) {
            return filepath;
        }
        return filepath.substring(index + 1);
    }

    public static void copyFileToDirectory(String source, String destinationDirectory) throws IOException {
        FileUtil.copyFileToDirectory(new File(source), new File(destinationDirectory));
    }

    public static void copyFileToDirectory(File source, File destinationDirectory) throws IOException {
        if (destinationDirectory.exists() && !destinationDirectory.isDirectory()) {
            throw new IllegalArgumentException("Destination is not a directory");
        }
        FileUtil.copyFile(source, new File(destinationDirectory, source.getName()));
    }

    public static void copyFile(File source, File destination) throws IOException {
        if (!source.exists()) {
            throw new IOException("File " + source + " does not exist");
        }
        if (!destination.getParentFile().exists()) {
            destination.mkdirs();
        }
        if (destination.exists() && !destination.canWrite()) {
            throw new IOException("Unable to open file " + destination + " for writing.");
        }
        FileInputStream input = new FileInputStream(source);
        FileOutputStream output = new FileOutputStream(destination);
        IOUtil.bufferedCopy(input, output);
        IOUtil.shutdownStream(input);
        IOUtil.shutdownStream(output);
        if (source.length() != destination.length()) {
            throw new IOException("Failed to copy full contents from " + source + " to " + destination);
        }
    }

    public static void copyURLToFile(URL source, File destination) throws IOException {
        if (!destination.getParentFile().exists()) {
            destination.mkdirs();
        }
        if (destination.exists() && !destination.canWrite()) {
            throw new IOException("Unable to open file " + destination + " for writing.");
        }
        InputStream input = source.openStream();
        FileOutputStream output = new FileOutputStream(destination);
        IOUtil.bufferedCopy(input, output);
        IOUtil.shutdownStream(input);
        IOUtil.shutdownStream(output);
    }

    public static String normalize(String location) {
        String loc = FileUtil.replaceSubString(location, "/./", "/");
        StringBuffer sb = new StringBuffer();
        int trail = 0;
        int end = loc.indexOf("/../");
        int start = 0;
        while (end != -1) {
            trail = loc.lastIndexOf("/", end - 1);
            sb.append(loc.substring(start, trail));
            sb.append('/');
            start = end + 4;
            end = loc.indexOf("/../", start);
        }
        end = loc.length();
        sb.append(loc.substring(start, end));
        return sb.toString();
    }

    public static String catPath(String lookupPath, String path) {
        int index = lookupPath.lastIndexOf("/");
        String lookup = lookupPath.substring(0, index);
        String pth = path;
        while (pth.startsWith("../")) {
            if (lookup.length() <= 0) {
                return null;
            }
            index = lookup.lastIndexOf("/");
            lookup = lookup.substring(0, index);
            index = pth.indexOf("../") + 3;
            pth = pth.substring(index);
        }
        return lookup + "/" + pth;
    }

    public static File resolveFile(File baseFile, String filename) {
        String filenm = null;
        if ('/' != File.separatorChar) {
            filenm = filename.replace('/', File.separatorChar);
        }
        if ('\\' != File.separatorChar) {
            filenm = filename.replace('\\', File.separatorChar);
        }
        if (filenm.startsWith(File.separator)) {
            File file = new File(filenm);
            try {
                file = file.getCanonicalFile();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            return file;
        }
        char[] chars = filename.toCharArray();
        StringBuffer sb = new StringBuffer();
        int start = 0;
        if ('\\' == File.separatorChar) {
            sb.append(filenm.charAt(0));
            ++start;
        }
        int i = start;
        while (i < chars.length) {
            boolean doubleSeperator;
            boolean bl = doubleSeperator = File.separatorChar == chars[i] && File.separatorChar == chars[i - 1];
            if (!doubleSeperator) {
                sb.append(chars[i]);
            }
            ++i;
        }
        filenm = sb.toString();
        File file = new File(baseFile, filenm).getAbsoluteFile();
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return file;
    }

    public static void forceDelete(String file) throws IOException {
        FileUtil.forceDelete(new File(file));
    }

    public static void forceDelete(File file) throws IOException {
        if (file.isDirectory()) {
            FileUtil.deleteDirectory(file);
        } else if (!file.delete()) {
            throw new IOException("File " + file + " unable to be deleted.");
        }
    }

    public static void deleteDirectory(String directory) throws IOException {
        FileUtil.deleteDirectory(new File(directory));
    }

    public static void deleteDirectory(File directory) throws IOException {
        if (!directory.exists()) {
            return;
        }
        FileUtil.cleanDirectory(directory);
        if (!directory.delete()) {
            throw new IOException("Directory " + directory + " unable to be deleted.");
        }
    }

    public static void cleanDirectory(String directory) throws IOException {
        FileUtil.cleanDirectory(new File(directory));
    }

    public static void cleanDirectory(File directory) throws IOException {
        if (!directory.exists()) {
            throw new IllegalArgumentException(directory + " does not exist");
        }
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException(directory + " is not a directory");
        }
        File[] files = directory.listFiles();
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            if (file.isFile()) {
                file.delete();
            } else if (file.isDirectory()) {
                FileUtil.cleanDirectory(file);
                if (!file.delete()) {
                    throw new IOException("Directory " + file + " unable to be deleted.");
                }
            }
            ++i;
        }
    }

    private static String replaceSubString(String original, String oldString, String newString) {
        StringBuffer sb = new StringBuffer();
        int end = original.indexOf(oldString);
        int start = 0;
        int stringSize = oldString.length();
        while (end != -1) {
            sb.append(original.substring(start, end));
            sb.append(newString);
            start = end + stringSize;
            end = original.indexOf(oldString, start);
        }
        end = original.length();
        sb.append(original.substring(start, end));
        return sb.toString();
    }

    private FileUtil() {
    }
}

