/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.camelot;

import java.net.URL;
import java.util.HashMap;
import org.apache.avalon.AbstractLoggable;
import org.apache.avalon.camelot.DefaultLoader;
import org.apache.avalon.camelot.Factory;
import org.apache.avalon.camelot.FactoryException;
import org.apache.avalon.camelot.Loader;
import org.apache.avalon.camelot.Locator;

public class DefaultFactory
extends AbstractLoggable
implements Factory {
    protected final HashMap m_loaders = new HashMap();

    public Object create(Locator locator) throws FactoryException {
        Loader loader = this.getLoaderFor(locator.getLocation());
        try {
            return loader.load(locator.getName());
        }
        catch (Exception exception) {
            throw new FactoryException("Unable to create " + locator.getName() + " from " + locator.getLocation(), exception);
        }
    }

    public Object create(Locator locator, Class clazz) throws FactoryException {
        Object object = this.create(locator);
        if (!clazz.isInstance(object)) {
            throw new FactoryException("Created object of type " + object.getClass().getName() + " not compatable with type " + clazz.getName());
        }
        return object;
    }

    protected Loader getLoaderFor(URL uRL) {
        String string = uRL.toString();
        LoaderEntry loaderEntry = (LoaderEntry)this.m_loaders.get(string);
        if (null == loaderEntry) {
            this.getLogger().info("Creating ClassLoader for " + string);
            loaderEntry = new LoaderEntry();
            loaderEntry.m_loader = this.setupLoader(uRL);
            loaderEntry.m_lastModified = System.currentTimeMillis();
            this.m_loaders.put(string, loaderEntry);
        }
        return loaderEntry.m_loader;
    }

    protected Loader setupLoader(URL uRL) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Loader loader = this.createLoader(uRL, classLoader);
        this.setupLogger(loader);
        return loader;
    }

    protected Loader createLoader(URL uRL, ClassLoader classLoader) {
        return new DefaultLoader(uRL, classLoader);
    }

    protected static class LoaderEntry {
        Loader m_loader;
        long m_lastModified;

        protected LoaderEntry() {
        }
    }
}

