/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.util.internet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ProtocolException;
import org.apache.avalon.util.internet.LineReader;
import org.apache.avalon.util.internet.LineWriter;

public class InternetStream {
    protected static final int MAX_OUTGOING_LINE_LENGTH = 512;
    protected LineReader m_reader;
    protected LineWriter m_writer;
    protected String m_lastLine;
    protected String m_responseText;
    protected int m_responseCode;
    protected String m_requestVerb;
    protected String m_requestParameter;

    public String getRequestVerb() {
        return this.m_requestVerb;
    }

    public String getRequestParameter() {
        return this.m_requestParameter;
    }

    public String getResponseText() {
        return this.m_responseText;
    }

    public int getResponseCode() {
        return this.m_responseCode;
    }

    public String getLastLine() {
        return this.m_lastLine;
    }

    public void sendRequest(String verb) throws IOException {
        this.sendRequest(verb, null);
    }

    public void sendRequest(String verb, String parameter) throws IOException {
        StringBuffer sb = new StringBuffer();
        sb.append(verb);
        if (parameter != null) {
            sb.append(' ');
            sb.append(parameter);
        }
        this.m_writer.println(sb.toString());
    }

    public void sendResponse(int responseCode, String message) throws IOException {
        int start = 0;
        int end = message.indexOf(10);
        while (-1 != end) {
            this.sendResponseLines(responseCode, false, message.substring(start, end));
            start = end + 1;
            end = message.indexOf(10, start);
        }
        end = message.length();
        this.sendResponseLines(responseCode, true, message.substring(start, end));
    }

    public void receiveRequest() throws IOException {
        this.m_requestVerb = null;
        this.m_requestParameter = null;
        String line = this.m_reader.readln();
        int space = line.indexOf(32);
        if (-1 == space) {
            this.m_requestVerb = line.toUpperCase();
        } else {
            this.m_requestVerb = line.substring(0, space).toUpperCase();
            this.m_requestParameter = line.substring(space + 1).trim();
            if (this.m_requestParameter.equals("")) {
                this.m_requestParameter = null;
            }
        }
    }

    public void receiveResponse() throws IOException {
        boolean lastLine = false;
        this.m_responseCode = 0;
        this.m_responseText = null;
        while (!lastLine) {
            String line = this.m_reader.readln();
            int responseCode = Integer.parseInt(line.substring(0, 3));
            if (this.m_responseCode != 0 && responseCode != this.m_responseCode) {
                throw new ProtocolException("Badly formed response with differing codes");
            }
            this.m_responseCode = responseCode;
            lastLine = ' ' == line.charAt(3);
            String messagePart = line.substring(4, line.length());
            this.m_responseText = this.m_responseText == null ? messagePart : this.m_responseText + "\n" + messagePart;
        }
    }

    protected void sendResponseLines(int responseCode, boolean isLastLine, String message) throws IOException {
        int size = message.length();
        if (size < 512) {
            this.sendResponseLine(responseCode, isLastLine, message);
        } else {
            int start = 0;
            int end = 512;
            while (end < size) {
                this.sendResponseLine(responseCode, false, message.substring(start, end));
                start = end + 1;
                end += 512;
            }
            this.sendResponseLine(responseCode, isLastLine, message.substring(start, size));
        }
    }

    protected void sendResponseLine(int responseCode, boolean isLastLine, String message) throws IOException {
        char seperator = isLastLine ? (char)' ' : '-';
        String responseLine = Integer.toString(responseCode) + seperator + message;
        this.sendLine(responseLine);
    }

    protected final void sendLine(String line) throws IOException {
        this.m_writer.println(line);
    }

    protected final String receiveLine() throws IOException {
        this.m_lastLine = this.m_reader.readln();
        return this.m_lastLine;
    }

    public InternetStream(InputStream input, OutputStream output) {
        this.m_reader = new LineReader(input);
        this.m_writer = new LineWriter(output);
    }
}

