/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.avalon.Configuration;
import org.apache.avalon.ConfigurationBuilder;
import org.apache.avalon.ConfigurationException;
import org.apache.avalon.SAXConfigurationHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class DefaultConfigurationBuilder
implements ConfigurationBuilder {
    protected static final String DEFAULT_PARSER = "org.apache.xerces.parsers.SAXParser";
    protected static final String PARSER = System.getProperty("org.xml.sax.parser", "org.apache.xerces.parsers.SAXParser");
    protected SAXConfigurationHandler m_handler = this.getHandler();
    protected XMLReader m_parser;

    protected SAXConfigurationHandler getHandler() {
        return new SAXConfigurationHandler();
    }

    public Configuration build(String resource) throws SAXException, IOException, ConfigurationException {
        Configuration configuration;
        FileInputStream input = new FileInputStream(resource);
        try {
            configuration = this.build(input);
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {
                ((InputStream)input).close();
            }
            catch (IOException ioe) {}
            throw throwable;
        }
        try {
            ((InputStream)input).close();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return configuration;
    }

    public Configuration build(InputStream inputStream) throws SAXException, IOException, ConfigurationException {
        InputSource inputSource = new InputSource(inputStream);
        return this.build(inputSource);
    }

    public Configuration build(InputSource input) throws SAXException, IOException, ConfigurationException {
        this.m_handler.clear();
        this.m_parser.parse(input);
        return this.m_handler.getConfiguration();
    }

    public DefaultConfigurationBuilder() {
        this(PARSER);
    }

    public DefaultConfigurationBuilder(String parserClass) {
        try {
            this.m_parser = XMLReaderFactory.createXMLReader(parserClass);
            this.m_parser.setContentHandler(this.m_handler);
            this.m_parser.setErrorHandler(this.m_handler);
        }
        catch (SAXException se) {
            throw new Error("Unable to setup SAX parser" + se);
        }
    }
}

