/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.catalog;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.avalon.excalibur.catalog.CatalogEntry;
import org.apache.avalon.excalibur.catalog.CatalogReader;
import org.apache.avalon.excalibur.catalog.NoXMLParserException;
import org.apache.avalon.excalibur.catalog.NotXMLCatalogException;
import org.apache.avalon.excalibur.catalog.UnknownCatalogFormatException;
import org.apache.avalon.excalibur.catalog.XMLCatalogReader;
import org.xml.sax.SAXException;

public class Catalog {
    public int debug = 0;
    private URL base;
    private URL catalogCwd;
    private Vector catalogEntries = new Vector();
    private boolean default_override = true;
    private Vector catalogFiles = new Vector();
    private Vector localCatalogFiles = new Vector();
    private Vector catalogs = new Vector();
    private Vector localDelegate = new Vector();
    private String parserClass = null;

    public void loadSystemCatalogs() throws MalformedURLException, IOException {
        String PCS = System.getProperty("path.separator");
        String catalog_files = System.getProperty("xml.catalog.files");
        while (catalog_files != null) {
            int pos = catalog_files.indexOf(PCS);
            String catfile = null;
            if (pos > 0) {
                catfile = catalog_files.substring(0, pos);
                catalog_files = catalog_files.substring(pos + 1);
            } else {
                catfile = catalog_files;
                catalog_files = null;
            }
            this.catalogFiles.addElement(catfile);
        }
        if (this.catalogFiles.size() > 0) {
            String catfile = (String)this.catalogFiles.lastElement();
            this.catalogFiles.removeElement(catfile);
            this.parseCatalog(catfile);
        }
    }

    public synchronized void parseCatalog(String fileName) throws MalformedURLException, IOException {
        this.catalogFiles.addElement(fileName);
        int curCat = 0;
        while (curCat < this.catalogFiles.size()) {
            String catfile = (String)this.catalogFiles.elementAt(curCat++);
            if (this.catalogEntries.size() == 0 && this.catalogs.size() == 0) {
                this.parseCatalogFile(catfile);
            } else {
                this.catalogs.addElement(catfile);
            }
            if (!this.localCatalogFiles.isEmpty()) {
                Vector newQueue = new Vector();
                Enumeration q = this.localCatalogFiles.elements();
                while (q.hasMoreElements()) {
                    newQueue.addElement(q.nextElement());
                }
                while (curCat < this.catalogFiles.size()) {
                    catfile = (String)this.catalogFiles.elementAt(curCat++);
                    newQueue.addElement(catfile);
                }
                this.localCatalogFiles = new Vector();
                this.catalogFiles = newQueue;
                curCat = 0;
            }
            if (this.localDelegate.isEmpty()) continue;
            Enumeration e = this.localDelegate.elements();
            while (e.hasMoreElements()) {
                this.catalogEntries.addElement(e.nextElement());
            }
            this.localDelegate = new Vector();
        }
        this.catalogFiles = new Vector();
    }

    public void parseAllCatalogs() throws MalformedURLException, IOException {
        int catPos = 0;
        while (catPos < this.catalogs.size()) {
            Catalog c = null;
            try {
                c = (Catalog)this.catalogs.elementAt(catPos);
            }
            catch (ClassCastException e) {
                String catfile = (String)this.catalogs.elementAt(catPos);
                c = new Catalog();
                c.setParserClass(this.parserClass);
                c.debug = this.debug;
                c.parseCatalog(catfile);
                this.catalogs.setElementAt(c, catPos);
                c.parseAllCatalogs();
            }
            ++catPos;
        }
        Enumeration enumeration = this.catalogEntries.elements();
        while (enumeration.hasMoreElements()) {
            CatalogEntry e = (CatalogEntry)enumeration.nextElement();
            if (e.entryType() != 6) continue;
            Catalog dcat = new Catalog();
            dcat.setParserClass(this.parserClass);
            dcat.debug = this.debug;
            dcat.parseCatalog(e.formalSystemIdentifier());
        }
    }

    public String resolveDoctype(String entityName, String publicId, String systemId) throws MalformedURLException, IOException {
        String resolved = null;
        if (systemId != null && (resolved = this.resolveLocalSystem(systemId)) != null) {
            return resolved;
        }
        if (publicId != null && (resolved = this.resolveLocalPublic(7, entityName, publicId, systemId)) != null) {
            return resolved;
        }
        boolean over = this.default_override;
        Enumeration enumeration = this.catalogEntries.elements();
        while (enumeration.hasMoreElements()) {
            CatalogEntry e = (CatalogEntry)enumeration.nextElement();
            if (e.entryType() == 4) {
                over = e.yes_or_no().equalsIgnoreCase("YES");
                continue;
            }
            if (e.entryType() != 7 || !e.entityName().equals(entityName) || !over && systemId != null) continue;
            return e.formalSystemIdentifier();
        }
        return this.resolveSubordinateCatalogs(7, entityName, publicId, systemId);
    }

    public String resolveDocument() throws MalformedURLException, IOException {
        Enumeration enumeration = this.catalogEntries.elements();
        while (enumeration.hasMoreElements()) {
            CatalogEntry e = (CatalogEntry)enumeration.nextElement();
            if (e.entryType() != 3) continue;
            return e.formalSystemIdentifier();
        }
        return this.resolveSubordinateCatalogs(3, null, null, null);
    }

    public String resolveEntity(String entityName, String publicId, String systemId) throws MalformedURLException, IOException {
        String resolved = null;
        if (systemId != null && (resolved = this.resolveLocalSystem(systemId)) != null) {
            return resolved;
        }
        if (publicId != null && (resolved = this.resolveLocalPublic(9, entityName, publicId, systemId)) != null) {
            return resolved;
        }
        boolean over = this.default_override;
        Enumeration enumeration = this.catalogEntries.elements();
        while (enumeration.hasMoreElements()) {
            CatalogEntry e = (CatalogEntry)enumeration.nextElement();
            if (e.entryType() == 4) {
                over = e.yes_or_no().equalsIgnoreCase("YES");
                continue;
            }
            if (e.entryType() != 9 || !e.entityName().equals(entityName) || !over && systemId != null) continue;
            return e.formalSystemIdentifier();
        }
        return this.resolveSubordinateCatalogs(9, entityName, publicId, systemId);
    }

    public String resolveNotation(String notationName, String publicId, String systemId) throws MalformedURLException, IOException {
        String resolved = null;
        if (systemId != null && (resolved = this.resolveLocalSystem(systemId)) != null) {
            return resolved;
        }
        if (publicId != null && (resolved = this.resolveLocalPublic(11, notationName, publicId, systemId)) != null) {
            return resolved;
        }
        boolean over = this.default_override;
        Enumeration enumeration = this.catalogEntries.elements();
        while (enumeration.hasMoreElements()) {
            CatalogEntry e = (CatalogEntry)enumeration.nextElement();
            if (e.entryType() == 4) {
                over = e.yes_or_no().equalsIgnoreCase("YES");
                continue;
            }
            if (e.entryType() != 11 || !e.entityName().equals(notationName) || !over && systemId != null) continue;
            return e.formalSystemIdentifier();
        }
        return this.resolveSubordinateCatalogs(11, notationName, publicId, systemId);
    }

    public String resolvePublic(String publicId, String systemId) throws MalformedURLException, IOException {
        String resolved;
        if (systemId != null && (resolved = this.resolveLocalSystem(systemId)) != null) {
            return resolved;
        }
        resolved = this.resolveLocalPublic(12, null, publicId, systemId);
        if (resolved != null) {
            return resolved;
        }
        return this.resolveSubordinateCatalogs(12, null, publicId, systemId);
    }

    public String resolveSystem(String systemId) throws MalformedURLException, IOException {
        String resolved;
        if (systemId != null && (resolved = this.resolveLocalSystem(systemId)) != null) {
            return resolved;
        }
        return this.resolveSubordinateCatalogs(13, null, null, systemId);
    }

    public void setParserClass(String parser) {
        this.parserClass = parser;
    }

    /*
     * WARNING - void declaration
     */
    private synchronized void parseCatalogFile(String fileName) throws MalformedURLException, IOException {
        CatalogEntry entry;
        Object catfile;
        try {
            String userdir = this.fixSlashes(System.getProperty("user.dir"));
            this.catalogCwd = new URL("file:///" + userdir + "/basename");
        }
        catch (MalformedURLException e) {
            String userdir = this.fixSlashes(System.getProperty("user.dir"));
            this.debug(1, "Malformed URL on cwd", userdir);
            this.catalogCwd = null;
        }
        try {
            this.base = new URL(this.catalogCwd, this.fixSlashes(fileName));
        }
        catch (MalformedURLException e) {
            try {
                this.base = new URL("file:///" + this.fixSlashes(fileName));
            }
            catch (MalformedURLException e2) {
                this.debug(1, "Malformed URL on catalog filename", this.fixSlashes(fileName));
                this.base = null;
            }
        }
        this.debug(1, "Loading catalog", fileName);
        this.debug(3, "Default BASE", this.base.toString());
        fileName = this.base.toString();
        if (this.parserClass != null) {
            try {
                catfile = new XMLCatalogReader();
                ((XMLCatalogReader)catfile).setParserClass(this.parserClass);
                ((XMLCatalogReader)catfile).parseCatalog(fileName);
                CatalogEntry ce = null;
                while ((ce = ((XMLCatalogReader)catfile).nextEntry()) != null) {
                    this.addEntry(ce);
                }
                return;
            }
            catch (SAXException e1) {
            }
            catch (NoXMLParserException e2) {
            }
            catch (NotXMLCatalogException e2) {
            }
            catch (InstantiationException e3) {
                this.debug(1, "Cannot instantiate XML Parser class", this.parserClass);
            }
            catch (IllegalAccessException e4) {
                this.debug(1, "Cannot access XML Parser class", this.parserClass);
            }
            catch (ClassNotFoundException e5) {
                this.debug(1, "Cannot load XML Parser class", this.parserClass);
            }
            catch (UnknownCatalogFormatException e6) {
                this.debug(1, "Unrecognized XML Catalog format.");
                return;
            }
        }
        catfile = new CatalogReader();
        ((CatalogReader)catfile).parseCatalog(fileName);
        while ((entry = ((CatalogReader)catfile).nextEntry()) != null) {
            void var2_14;
            this.addEntry((CatalogEntry)var2_14);
        }
    }

    private void addEntry(CatalogEntry entry) {
        switch (entry.entryType()) {
            case 1: {
                String value = entry.formalSystemIdentifier();
                URL newbase = null;
                this.debug(3, "BASE", value);
                try {
                    value = this.fixSlashes(value);
                    newbase = new URL(this.catalogCwd, value);
                }
                catch (MalformedURLException e) {
                    try {
                        newbase = new URL("file:///" + value);
                    }
                    catch (MalformedURLException e2) {
                        this.debug(1, "Malformed URL on base", value);
                        newbase = null;
                    }
                }
                if (newbase == null) break;
                this.base = newbase;
                break;
            }
            case 2: {
                String fsi = this.makeAbsolute(entry.formalSystemIdentifier());
                this.debug(3, "CATALOG", fsi);
                this.localCatalogFiles.addElement(fsi);
                break;
            }
            case 3: {
                String fsi = this.makeAbsolute(entry.formalSystemIdentifier());
                entry.updateFormalSystemIdentifier(fsi);
                this.debug(3, "DOCUMENT", fsi);
                this.catalogEntries.addElement(entry);
                break;
            }
            case 4: {
                this.debug(3, "OVERRIDE", entry.yes_or_no());
                this.catalogEntries.addElement(entry);
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                String fsi = this.makeAbsolute(entry.formalSystemIdentifier());
                entry.updateFormalSystemIdentifier(fsi);
                this.debug(3, "DELEGATE", entry.partialPublicId(), fsi);
                this.addDelegate(entry);
                break;
            }
            case 7: {
                String fsi = this.makeAbsolute(entry.formalSystemIdentifier());
                entry.updateFormalSystemIdentifier(fsi);
                this.debug(3, "DOCTYPE", entry.publicId(), fsi);
                this.catalogEntries.addElement(entry);
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                String fsi = this.makeAbsolute(entry.formalSystemIdentifier());
                entry.updateFormalSystemIdentifier(fsi);
                this.debug(3, "ENTITY", entry.entityName(), fsi);
                this.catalogEntries.addElement(entry);
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                String fsi = this.makeAbsolute(entry.formalSystemIdentifier());
                entry.updateFormalSystemIdentifier(fsi);
                this.debug(3, "NOTATION", entry.entityName(), fsi);
                this.catalogEntries.addElement(entry);
                break;
            }
            case 12: {
                String publicid = entry.publicId();
                String systemid = this.makeAbsolute(entry.formalSystemIdentifier());
                this.debug(3, "PUBLIC", publicid, systemid);
                entry.updateFormalSystemIdentifier(systemid);
                this.catalogEntries.addElement(entry);
                break;
            }
            case 13: {
                String systemid = entry.systemId();
                String fsi = this.makeAbsolute(entry.formalSystemIdentifier());
                this.debug(3, "SYSTEM", systemid, fsi);
                entry.updateFormalSystemIdentifier(fsi);
                this.catalogEntries.addElement(entry);
                break;
            }
        }
    }

    private synchronized String resolveLocalPublic(int entityType, String entityName, String publicId, String systemId) throws MalformedURLException, IOException {
        String resolved;
        publicId = CatalogReader.normalize(publicId);
        if (systemId != null && (resolved = this.resolveLocalSystem(systemId)) != null) {
            return resolved;
        }
        boolean over = this.default_override;
        Enumeration enumeration = this.catalogEntries.elements();
        while (enumeration.hasMoreElements()) {
            CatalogEntry e = (CatalogEntry)enumeration.nextElement();
            if (e.entryType() == 4) {
                over = e.yes_or_no().equalsIgnoreCase("YES");
                continue;
            }
            if (e.entryType() != 12 || !e.publicId().equals(publicId) || !over && systemId != null) continue;
            return e.formalSystemIdentifier();
        }
        over = this.default_override;
        enumeration = this.catalogEntries.elements();
        Vector<String> delCats = new Vector<String>();
        while (enumeration.hasMoreElements()) {
            String p;
            CatalogEntry e = (CatalogEntry)enumeration.nextElement();
            if (e.entryType() == 4) {
                over = e.yes_or_no().equalsIgnoreCase("YES");
                continue;
            }
            if (e.entryType() != 6 || !over && systemId != null || (p = e.partialPublicId()).length() > publicId.length() || !p.equals(publicId.substring(0, p.length()))) continue;
            delCats.addElement(e.formalSystemIdentifier());
        }
        if (delCats.size() > 0) {
            Enumeration enumCats = delCats.elements();
            if (this.debug > 0) {
                this.debug(1, "Switching to delegated catalog(s):");
                while (enumCats.hasMoreElements()) {
                    String delegatedCatalog = (String)enumCats.nextElement();
                    this.debug(1, "\t" + delegatedCatalog);
                }
            }
            Catalog dcat = new Catalog();
            dcat.setParserClass(this.parserClass);
            dcat.debug = this.debug;
            enumCats = delCats.elements();
            while (enumCats.hasMoreElements()) {
                String delegatedCatalog = (String)enumCats.nextElement();
                dcat.parseCatalog(delegatedCatalog);
            }
            return dcat.resolvePublic(publicId, null);
        }
        return null;
    }

    private String resolveLocalSystem(String systemId) {
        String osname = System.getProperty("os.name");
        boolean windows = osname.indexOf("Windows") >= 0;
        Enumeration enumeration = this.catalogEntries.elements();
        while (enumeration.hasMoreElements()) {
            CatalogEntry e = (CatalogEntry)enumeration.nextElement();
            if (e.entryType() != 13 || !e.systemId().equals(systemId) && (!windows || !e.systemId().equalsIgnoreCase(systemId))) continue;
            return e.formalSystemIdentifier();
        }
        return null;
    }

    private synchronized String resolveSubordinateCatalogs(int entityType, String entityName, String publicId, String systemId) throws MalformedURLException, IOException {
        int catPos = 0;
        while (catPos < this.catalogs.size()) {
            Catalog c = null;
            try {
                c = (Catalog)this.catalogs.elementAt(catPos);
            }
            catch (ClassCastException e) {
                String catfile = (String)this.catalogs.elementAt(catPos);
                c = new Catalog();
                c.setParserClass(this.parserClass);
                c.debug = this.debug;
                try {
                    c.parseCatalog(catfile);
                }
                catch (MalformedURLException mue) {
                    this.debug(1, "Malformed Catalog URL", catfile);
                }
                catch (FileNotFoundException fnfe) {
                    this.debug(1, "Failed to load catalog, file not found", catfile);
                }
                catch (IOException ioe) {
                    this.debug(1, "Failed to load catalog, I/O error", catfile);
                }
                this.catalogs.setElementAt(c, catPos);
            }
            String resolved = null;
            switch (entityType) {
                case 7: {
                    resolved = c.resolveDoctype(entityName, publicId, systemId);
                    break;
                }
                case 3: {
                    resolved = c.resolveDocument();
                    break;
                }
                case 9: {
                    resolved = c.resolveEntity(entityName, publicId, systemId);
                    break;
                }
                case 11: {
                    resolved = c.resolveNotation(entityName, publicId, systemId);
                    break;
                }
                case 12: {
                    resolved = c.resolvePublic(publicId, systemId);
                    break;
                }
                case 13: {
                    resolved = c.resolveSystem(systemId);
                    break;
                }
            }
            if (resolved != null) {
                return resolved;
            }
            ++catPos;
        }
        return null;
    }

    private String fixSlashes(String sysid) {
        return sysid.replace('\\', '/');
    }

    private String makeAbsolute(String sysid) {
        URL local = null;
        sysid = this.fixSlashes(sysid);
        try {
            local = new URL(this.base, sysid);
        }
        catch (MalformedURLException e) {
            this.debug(1, "Malformed URL on system identifier", sysid);
        }
        if (local != null) {
            return local.toString();
        }
        return sysid;
    }

    private void debug(int level, String message) {
        if (this.debug >= level) {
            System.out.println(message);
        }
    }

    private void debug(int level, String message, String spec) {
        if (this.debug >= level) {
            System.out.println(new StringBuffer(message).append(": ").append(spec));
        }
    }

    private void debug(int level, String message, String spec1, String spec2) {
        if (this.debug >= level) {
            System.out.println(new StringBuffer(message).append(": ").append(spec1));
            System.out.println("\t" + spec2);
        }
    }

    private void addDelegate(CatalogEntry entry) {
        int pos = 0;
        String partial = entry.partialPublicId();
        Enumeration local = this.localDelegate.elements();
        while (local.hasMoreElements()) {
            CatalogEntry dpe = (CatalogEntry)local.nextElement();
            String dp = dpe.partialPublicId();
            if (dp.equals(partial)) {
                return;
            }
            if (dp.length() > partial.length()) {
                ++pos;
            }
            if (dp.length() < partial.length()) break;
        }
        if (this.localDelegate.size() == 0) {
            this.localDelegate.addElement(entry);
        } else {
            this.localDelegate.insertElementAt(entry, pos);
        }
    }

    public Catalog() {
        String property = System.getProperty("xml.catalog.debug");
        if (property != null) {
            try {
                this.debug = Integer.parseInt(property);
            }
            catch (NumberFormatException e) {
                this.debug = 0;
            }
        }
        if ((property = System.getProperty("xml.catalog.override")) != null) {
            this.default_override = property.equalsIgnoreCase("true") || property.equalsIgnoreCase("yes") || property.equalsIgnoreCase("1");
        }
    }
}

