/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ant.antunit.listener;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.NumberFormat;
import org.apache.ant.antunit.AntUnitListener;
import org.apache.ant.antunit.AssertionFailedException;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.TeeOutputStream;

public abstract class BaseAntUnitListener
implements AntUnitListener {
    protected static final NumberFormat nf = NumberFormat.getInstance();
    private File toDir;
    private String extension;
    private SendLogTo logTo;
    private Task parentTask;
    protected int runCount;
    protected int failureCount;
    protected int errorCount;
    protected long start;
    protected long testStart;
    private Project currentTest;
    private AntUnitLogLevel logLevel;

    protected BaseAntUnitListener(SendLogTo defaultReportTarget, String extension) {
        this.logTo = defaultReportTarget;
        this.extension = extension;
        this.logLevel = AntUnitLogLevel.NONE;
    }

    protected final File getToDir() {
        return this.toDir;
    }

    public void setToDir(File f) {
        this.toDir = f;
    }

    protected void setSendLogTo(SendLogTo logTo) {
        this.logTo = logTo;
    }

    public void setParentTask(Task t) {
        this.parentTask = t;
    }

    public void startTestSuite(Project testProject, String buildFile) {
        this.start = System.currentTimeMillis();
        this.errorCount = 0;
        this.failureCount = 0;
        this.runCount = 0;
    }

    protected final void close(OutputStream out) {
        if (out != System.out && out != System.err) {
            FileUtils.close((OutputStream)out);
        }
    }

    public void startTest(String target) {
        this.testStart = System.currentTimeMillis();
        ++this.runCount;
    }

    public void addFailure(String target, AssertionFailedException ae) {
        ++this.failureCount;
    }

    public void addError(String target, Throwable ae) {
        ++this.errorCount;
    }

    protected final OutputStream getOut(String buildFile) {
        OutputStream f = null;
        PrintStream l = null;
        if (this.logTo.getValue().equals("ant") || this.logTo.getValue().equals("both")) {
            l = this.parentTask != null ? new LogOutputStream(this.parentTask, 2) : System.out;
            if (this.logTo.getValue().equals("ant")) {
                return l;
            }
        }
        if (this.logTo.getValue().equals("file") || this.logTo.getValue().equals("both")) {
            String fileName = "TEST-" + this.normalize(buildFile) + "." + this.extension;
            File file = this.toDir == null ? (this.parentTask != null ? this.parentTask.getProject().resolveFile(fileName) : new File(fileName)) : new File(this.toDir, fileName);
            try {
                f = new FileOutputStream(file);
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e);
            }
            if (this.logTo.getValue().equals("file")) {
                return f;
            }
        }
        return new TeeOutputStream((OutputStream)l, f);
    }

    protected final String normalize(String buildFile) {
        File base = this.parentTask != null ? this.parentTask.getProject().getBaseDir() : new File(System.getProperty("user.dir"));
        buildFile = FileUtils.getFileUtils().removeLeadingPath(base, new File(buildFile));
        if (buildFile.length() > 0 && buildFile.charAt(0) == File.separatorChar) {
            buildFile = buildFile.substring(1);
        }
        return buildFile.replace('.', '_').replace(':', '_').replace(File.separatorChar, '.');
    }

    protected final Location getLocation(Throwable t) {
        Location l2;
        Location l = Location.UNKNOWN_LOCATION;
        if (t instanceof BuildException && (l2 = ((BuildException)t).getLocation()) != null) {
            l = l2;
        }
        return l;
    }

    public void setCurrentTestProject(Project p) {
        this.currentTest = p;
        p.addBuildListener((BuildListener)new LogGrabber());
    }

    protected Project getCurrentTestProject() {
        return this.currentTest;
    }

    public void setLogLevel(AntUnitLogLevel l) {
        this.logLevel = l;
    }

    protected void messageLogged(BuildEvent event) {
    }

    public class LogGrabber
    implements BuildListener {
        public void buildStarted(BuildEvent event) {
        }

        public void buildFinished(BuildEvent event) {
        }

        public void targetStarted(BuildEvent event) {
        }

        public void targetFinished(BuildEvent event) {
        }

        public void taskStarted(BuildEvent event) {
        }

        public void taskFinished(BuildEvent event) {
        }

        public void messageLogged(BuildEvent event) {
            int priority = event.getPriority();
            if (priority <= BaseAntUnitListener.this.logLevel.getLevel()) {
                BaseAntUnitListener.this.messageLogged(event);
            }
        }
    }

    public static class AntUnitLogLevel
    extends EnumeratedAttribute {
        public static final AntUnitLogLevel NONE = new AntUnitLogLevel("none");
        private static int[] levels = new int[]{-1, 0, 1, 1, 2, 3, 4};

        public AntUnitLogLevel() {
        }

        private AntUnitLogLevel(String value) {
            this.setValue(value);
        }

        public String[] getValues() {
            return new String[]{"none", "error", "warn", "warning", "info", "verbose", "debug"};
        }

        public int getLevel() {
            return levels[this.getIndex()];
        }
    }

    public static class SendLogTo
    extends EnumeratedAttribute {
        public static final String ANT_LOG = "ant";
        public static final String FILE = "file";
        public static final String BOTH = "both";

        public SendLogTo() {
        }

        public SendLogTo(String s) {
            this.setValue(s);
        }

        public String[] getValues() {
            return new String[]{ANT_LOG, FILE, BOTH};
        }
    }
}

