/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.util;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.util.HashMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.tools.ant.AntClassLoader;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.ParserAdapter;
import xdoclet.XDocletException;
import xdoclet.util.FileManager;
import xdoclet.util.LogUtil;
import xdoclet.util.Translator;

public class XmlValidator
extends DefaultHandler {
    public static String DEFAULT_XML_READER_CLASSNAME = "org.apache.crimson.parser.XMLReaderImpl";
    private static XmlValidator instance = new XmlValidator(null);
    protected ClassLoader classLoader;
    protected XMLReader xmlReader = null;
    protected String readerClassName = DEFAULT_XML_READER_CLASSNAME;
    private final HashMap _dtds = new HashMap();
    static /* synthetic */ Class class$xdoclet$util$XmlValidator;
    static /* synthetic */ Class class$xdoclet$XDocletMessages;
    static /* synthetic */ Class class$org$xml$sax$XMLReader;
    static /* synthetic */ Class class$org$xml$sax$Parser;
    static /* synthetic */ Class class$xdoclet$util$XDocletUtilMessages;

    public XmlValidator(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public static XmlValidator getInstance() {
        return instance;
    }

    public static void setInstance(XmlValidator instance) {
        XmlValidator.instance = instance;
    }

    public void registerDTD(String publicId, URL dtdURL) {
        Log log = LogUtil.getLog(class$xdoclet$util$XmlValidator == null ? (class$xdoclet$util$XmlValidator = XmlValidator.class$("xdoclet.util.XmlValidator")) : class$xdoclet$util$XmlValidator, "registerDTD");
        if (log.isDebugEnabled()) {
            log.debug((Object)("DTD '" + dtdURL + "' registered for public Id '" + publicId + "'."));
        }
        this._dtds.put(publicId, dtdURL);
    }

    public InputSource resolveEntity(String publicId, String systemId) {
        URL dtdURL;
        Log log = LogUtil.getLog(class$xdoclet$util$XmlValidator == null ? (class$xdoclet$util$XmlValidator = XmlValidator.class$("xdoclet.util.XmlValidator")) : class$xdoclet$util$XmlValidator, "resolveEntity");
        if (log.isDebugEnabled()) {
            log.debug((Object)("publicId=" + publicId));
            log.debug((Object)("systemId=" + systemId));
        }
        if ((dtdURL = (URL)this._dtds.get(publicId)) != null) {
            String dtd = FileManager.getURLContent(dtdURL);
            if (log.isDebugEnabled()) {
                log.debug((Object)("dtdURL != null, dtdURL=" + dtdURL));
                log.debug((Object)("dtd.length()=" + dtd.length()));
            }
            return new InputSource(new StringReader(dtd));
        }
        log.debug((Object)"dtdURL == null");
        log.error((Object)Translator.getString(class$xdoclet$XDocletMessages == null ? (class$xdoclet$XDocletMessages = XmlValidator.class$("xdoclet.XDocletMessages")) : class$xdoclet$XDocletMessages, "COULDNT_LOAD_LOCAL_DTD", new String[]{publicId}));
        return null;
    }

    public void error(SAXParseException e) throws SAXParseException {
        throw e;
    }

    public void warning(SAXParseException e) throws SAXParseException {
    }

    public void validate(File xmlFile) throws XDocletException {
        if (this.classLoader == null) {
            this.initValidator();
        } else {
            this.initValidatorHack();
        }
        this.doValidate(xmlFile);
    }

    private void doValidate(File xml_file) throws XDocletException {
        Log log = LogUtil.getLog(class$xdoclet$util$XmlValidator == null ? (class$xdoclet$util$XmlValidator = XmlValidator.class$("xdoclet.util.XmlValidator")) : class$xdoclet$util$XmlValidator, "doValidate");
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Validating " + xml_file.getName() + "... "));
            }
            InputSource is = new InputSource(new FileReader(xml_file));
            String uri = "file:" + xml_file.getAbsolutePath().replace('\\', '/');
            int index = uri.indexOf(35);
            while (index != -1) {
                uri = uri.substring(0, index) + "%23" + uri.substring(index + 1);
                index = uri.indexOf(35);
            }
            is.setSystemId(uri);
            this.xmlReader.parse(is);
        }
        catch (SAXException e) {
            e.printStackTrace();
            throw new XDocletException("Couldn't validate document " + xml_file);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new XDocletException(e, "Couldn't validate document " + xml_file);
        }
    }

    private void initValidatorHack() throws XDocletException {
        block14: {
            Log log = LogUtil.getLog(class$xdoclet$util$XmlValidator == null ? (class$xdoclet$util$XmlValidator = XmlValidator.class$("xdoclet.util.XmlValidator")) : class$xdoclet$util$XmlValidator, "initValidator");
            try {
                Class<?> readerClass = null;
                if (this.classLoader != null) {
                    readerClass = this.classLoader.loadClass(this.readerClassName);
                    AntClassLoader.initializeClass(readerClass);
                } else {
                    readerClass = Class.forName(this.readerClassName);
                }
                if ((class$org$xml$sax$XMLReader == null ? (class$org$xml$sax$XMLReader = XmlValidator.class$("org.xml.sax.XMLReader")) : class$org$xml$sax$XMLReader).isAssignableFrom(readerClass)) {
                    this.xmlReader = (XMLReader)readerClass.newInstance();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Using SAX2 reader " + this.readerClassName));
                    }
                    break block14;
                }
                if ((class$org$xml$sax$Parser == null ? (class$org$xml$sax$Parser = XmlValidator.class$("org.xml.sax.Parser")) : class$org$xml$sax$Parser).isAssignableFrom(readerClass)) {
                    Parser parser = (Parser)readerClass.newInstance();
                    this.xmlReader = new ParserAdapter(parser);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Using SAX1 parser " + this.readerClassName));
                    }
                    break block14;
                }
                String message = Translator.getString(class$xdoclet$util$XDocletUtilMessages == null ? (class$xdoclet$util$XDocletUtilMessages = XmlValidator.class$("xdoclet.util.XDocletUtilMessages")) : class$xdoclet$util$XDocletUtilMessages, "INIT_FAILED", new String[]{this.readerClassName});
                System.out.println("init_failed");
                throw new XDocletException(message);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                String message = Translator.getString(class$xdoclet$util$XDocletUtilMessages == null ? (class$xdoclet$util$XDocletUtilMessages = XmlValidator.class$("xdoclet.util.XDocletUtilMessages")) : class$xdoclet$util$XDocletUtilMessages, "INIT_FAILED", new String[]{this.readerClassName});
                throw new XDocletException(e, message);
            }
            catch (InstantiationException e) {
                e.printStackTrace();
                String message = Translator.getString(class$xdoclet$util$XDocletUtilMessages == null ? (class$xdoclet$util$XDocletUtilMessages = XmlValidator.class$("xdoclet.util.XDocletUtilMessages")) : class$xdoclet$util$XDocletUtilMessages, "INIT_FAILED", new String[]{this.readerClassName});
                throw new XDocletException(e, message);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                String message = Translator.getString(class$xdoclet$util$XDocletUtilMessages == null ? (class$xdoclet$util$XDocletUtilMessages = XmlValidator.class$("xdoclet.util.XDocletUtilMessages")) : class$xdoclet$util$XDocletUtilMessages, "INIT_FAILED", new String[]{this.readerClassName});
                throw new XDocletException(e, message);
            }
        }
        this.xmlReader.setEntityResolver(this);
        if (!(this.xmlReader instanceof ParserAdapter)) {
            try {
                this.xmlReader.setFeature("http://xml.org/sax/features/validation", true);
            }
            catch (SAXNotRecognizedException e) {
                e.printStackTrace();
            }
            catch (SAXNotSupportedException e) {
                e.printStackTrace();
            }
        }
    }

    private void initValidator() throws XDocletException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(true);
            this.xmlReader = factory.newSAXParser().getXMLReader();
            this.xmlReader.setEntityResolver(this);
            this.xmlReader.setErrorHandler(this);
        }
        catch (SAXParseException e) {
            String message = Translator.getString(class$xdoclet$util$XDocletUtilMessages == null ? (class$xdoclet$util$XDocletUtilMessages = XmlValidator.class$("xdoclet.util.XDocletUtilMessages")) : class$xdoclet$util$XDocletUtilMessages, "INIT_FAILED", new String[]{e.getSystemId(), Integer.toString(e.getLineNumber()), e.getMessage()});
            throw new XDocletException(e, message);
        }
        catch (SAXException e) {
            throw new XDocletException(e, Translator.getString(class$xdoclet$XDocletMessages == null ? (class$xdoclet$XDocletMessages = XmlValidator.class$("xdoclet.XDocletMessages")) : class$xdoclet$XDocletMessages, "COULDNT_INIT_XML_PARSER"));
        }
        catch (ParserConfigurationException e) {
            throw new XDocletException(e, Translator.getString(class$xdoclet$XDocletMessages == null ? (class$xdoclet$XDocletMessages = XmlValidator.class$("xdoclet.XDocletMessages")) : class$xdoclet$XDocletMessages, "COULDNT_CONF_XML_PARSER"));
        }
        catch (NullPointerException e) {
            throw new XDocletException(e, Translator.getString(class$xdoclet$XDocletMessages == null ? (class$xdoclet$XDocletMessages = XmlValidator.class$("xdoclet.XDocletMessages")) : class$xdoclet$XDocletMessages, "COULDNT_LOAD_DTD"));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

