/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.datasource;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.avalon.excalibur.datasource.DataSourceComponent;
import org.apache.avalon.excalibur.datasource.JdbcConnectionFactory;
import org.apache.avalon.excalibur.datasource.JdbcConnectionPool;
import org.apache.avalon.excalibur.pool.DefaultPoolController;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLoggable;

public class JdbcDataSource
extends AbstractLoggable
implements DataSourceComponent,
Disposable {
    protected JdbcConnectionPool m_pool;

    public void configure(Configuration configuration) throws ConfigurationException {
        if (this.m_pool == null) {
            int l_max;
            int n;
            int l_min;
            String dburl = configuration.getChild("dburl").getValue();
            String user = configuration.getChild("user").getValue(null);
            String passwd = configuration.getChild("password").getValue(null);
            Configuration controller = configuration.getChild("pool-controller");
            int min = controller.getAttributeAsInteger("min", 1);
            int max = controller.getAttributeAsInteger("max", 3);
            boolean autoCommit = configuration.getChild("auto-commit").getValueAsBoolean(true);
            boolean oradb = controller.getAttributeAsBoolean("oradb", false);
            if (min < 1) {
                this.getLogger().warn("Minumum number of connections specified must be at least 1.");
                boolean bl = true;
            } else {
                l_min = min;
            }
            if (max < 1) {
                this.getLogger().warn("Maximum number of connections specified must be at least 1.");
                n = 1;
            } else if (max < min) {
                this.getLogger().warn("Maximum number of connections specified must be more than the minimum number of connections.");
                n = min + 1;
            } else {
                l_max = max;
            }
            JdbcConnectionFactory factory = new JdbcConnectionFactory(dburl, user, passwd, autoCommit, oradb);
            DefaultPoolController poolController = new DefaultPoolController(l_max / 4);
            factory.setLogger(this.getLogger());
            try {
                this.m_pool = new JdbcConnectionPool(factory, poolController, l_min, l_max, autoCommit);
                this.m_pool.setLogger(this.getLogger());
                this.m_pool.initialize();
            }
            catch (Exception e) {
                this.getLogger().debug("Error on configuration", (Throwable)e);
                throw new ConfigurationException("Error on configuration", (Throwable)e);
            }
        }
    }

    public Connection getConnection() throws SQLException {
        try {
            return (Connection)((Object)this.m_pool.get());
        }
        catch (Exception e) {
            this.getLogger().error("Could not return Connection", (Throwable)e);
            throw new SQLException(e.getMessage());
        }
    }

    public void dispose() {
        this.m_pool.dispose();
        this.m_pool = null;
    }
}

