/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Path;

public class AntClassLoader
extends ClassLoader {
    private static final int BUFFER_SIZE = 1024;
    private Path classpath;
    private Project project;
    private boolean systemFirst = true;
    private Vector systemPackages = new Vector();
    private Vector loaderPackages = new Vector();
    private boolean ignoreBase = false;
    private static Method getProtectionDomain = null;
    private static Method defineClassProtectionDomain = null;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$org$apache$tools$ant$AntClassLoader;
    static /* synthetic */ Class class$org$apache$tools$ant$Project;

    public AntClassLoader(Project project, Path path) {
        this.project = project;
        this.classpath = path.concatSystemClasspath("ignore");
        this.addSystemPackageRoot("java");
        this.addSystemPackageRoot("javax");
    }

    public AntClassLoader(Project project, Path path, boolean bl) {
        this(project, path);
        this.systemFirst = bl;
    }

    public void setIsolated(boolean bl) {
        this.ignoreBase = bl;
    }

    public static void initializeClass(Class clazz) {
        try {
            clazz.newInstance();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void addSystemPackageRoot(String string) {
        this.systemPackages.addElement(string + ".");
    }

    public void addLoaderPackageRoot(String string) {
        this.loaderPackages.addElement(string + ".");
    }

    public Class forceLoadClass(String string) throws ClassNotFoundException {
        this.project.log("force loading " + string, 4);
        Class clazz = this.findLoadedClass(string);
        if (clazz == null) {
            clazz = this.findClass(string);
        }
        return clazz;
    }

    public Class forceLoadSystemClass(String string) throws ClassNotFoundException {
        this.project.log("force system loading " + string, 4);
        Class clazz = this.findLoadedClass(string);
        if (clazz == null) {
            clazz = this.findBaseClass(string);
        }
        return clazz;
    }

    public InputStream getResourceAsStream(String string) {
        InputStream inputStream = null;
        if (this.isSystemFirst(string)) {
            inputStream = this.loadBaseResource(string);
            if (inputStream == null) {
                inputStream = this.loadResource(string);
            }
        } else {
            inputStream = this.loadResource(string);
            if (inputStream == null) {
                inputStream = this.loadBaseResource(string);
            }
        }
        return inputStream;
    }

    private InputStream loadResource(String string) {
        InputStream inputStream = null;
        String[] stringArray = this.classpath.list();
        int n = 0;
        while (n < stringArray.length && inputStream == null) {
            File file = this.project.resolveFile(stringArray[n]);
            inputStream = this.getResourceStream(file, string);
            ++n;
        }
        return inputStream;
    }

    private InputStream loadBaseResource(String string) {
        ClassLoader classLoader = (class$org$apache$tools$ant$AntClassLoader == null ? (class$org$apache$tools$ant$AntClassLoader = AntClassLoader.class$("org.apache.tools.ant.AntClassLoader")) : class$org$apache$tools$ant$AntClassLoader).getClassLoader();
        if (classLoader == null) {
            return ClassLoader.getSystemResourceAsStream(string);
        }
        return classLoader.getResourceAsStream(string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private InputStream getResourceStream(File file, String string) {
        try {
            ZipFile zipFile;
            block7: {
                ByteArrayInputStream byteArrayInputStream;
                if (!file.exists()) {
                    return null;
                }
                if (file.isDirectory()) {
                    File file2 = new File(file, string);
                    if (!file2.exists()) return null;
                    return new FileInputStream(file2);
                }
                zipFile = null;
                try {
                    int n;
                    zipFile = new ZipFile(file);
                    ZipEntry zipEntry = zipFile.getEntry(string);
                    if (zipEntry == null) break block7;
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    byte[] byArray = new byte[1024];
                    InputStream inputStream = zipFile.getInputStream(zipEntry);
                    while ((n = inputStream.read(byArray, 0, 1024)) != -1) {
                        byteArrayOutputStream.write(byArray, 0, n);
                    }
                    byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                    Object var11_12 = null;
                    if (zipFile == null) return byteArrayInputStream;
                }
                catch (Throwable throwable) {
                    Object var11_14 = null;
                    if (zipFile == null) throw throwable;
                    zipFile.close();
                    throw throwable;
                }
                zipFile.close();
                return byteArrayInputStream;
            }
            Object var11_13 = null;
            if (zipFile == null) return null;
            zipFile.close();
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    private boolean isSystemFirst(String string) {
        Object object;
        boolean bl = this.systemFirst;
        Enumeration enumeration = this.systemPackages.elements();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (!string.startsWith((String)object)) continue;
            bl = true;
            break;
        }
        object = this.loaderPackages.elements();
        while (object.hasMoreElements()) {
            String string2 = (String)object.nextElement();
            if (!string.startsWith(string2)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public URL getResource(String string) {
        URL uRL = null;
        if (this.isSystemFirst(string)) {
            uRL = super.getResource(string);
        }
        if (uRL == null) {
            String[] stringArray = this.classpath.list();
            int n = 0;
            while (n < stringArray.length && uRL == null) {
                File file = this.project.resolveFile(stringArray[n]);
                uRL = this.getResourceURL(file, string);
                ++n;
            }
        }
        if (uRL == null && !this.isSystemFirst(string)) {
            uRL = super.getResource(string);
        }
        return uRL;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private URL getResourceURL(File file, String string) {
        try {
            ZipFile zipFile;
            block10: {
                URL uRL;
                if (!file.exists()) {
                    return null;
                }
                if (file.isDirectory()) {
                    File file2 = new File(file, string);
                    if (!file2.exists()) return null;
                    try {
                        return new URL("file:" + file2.toString());
                    }
                    catch (MalformedURLException malformedURLException) {
                        return null;
                    }
                }
                zipFile = null;
                try {
                    zipFile = new ZipFile(file);
                    ZipEntry zipEntry = zipFile.getEntry(string);
                    if (zipEntry == null) break block10;
                    try {
                        uRL = new URL("jar:file:" + file.toString() + "!/" + zipEntry);
                        Object var8_10 = null;
                        if (zipFile == null) return uRL;
                    }
                    catch (MalformedURLException malformedURLException) {
                        URL uRL2 = null;
                        Object var8_11 = null;
                        if (zipFile == null) return uRL2;
                        zipFile.close();
                        return uRL2;
                    }
                }
                catch (Throwable throwable) {
                    Object var8_13 = null;
                    if (zipFile == null) throw throwable;
                    zipFile.close();
                    throw throwable;
                }
                zipFile.close();
                return uRL;
            }
            Object var8_12 = null;
            if (zipFile == null) return null;
            zipFile.close();
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    protected Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class clazz = this.findLoadedClass(string);
        if (clazz != null) {
            return clazz;
        }
        if (this.isSystemFirst(string)) {
            try {
                clazz = this.findBaseClass(string);
                this.project.log("Class " + string + " loaded from system loader", 4);
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz = this.findClass(string);
                this.project.log("Class " + string + " loaded from ant loader", 4);
            }
        } else {
            try {
                clazz = this.findClass(string);
                this.project.log("Class " + string + " loaded from ant loader", 4);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (this.ignoreBase) {
                    throw classNotFoundException;
                }
                clazz = this.findBaseClass(string);
                this.project.log("Class " + string + " loaded from system loader", 4);
            }
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    private String getClassFilename(String string) {
        return string.replace('.', '/') + ".class";
    }

    private Class getClassFromStream(InputStream inputStream, String string) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = -1;
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray, 0, 1024)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        if (defineClassProtectionDomain != null) {
            try {
                Object object = getProtectionDomain.invoke((Object)(class$org$apache$tools$ant$Project == null ? (class$org$apache$tools$ant$Project = AntClassLoader.class$("org.apache.tools.ant.Project")) : class$org$apache$tools$ant$Project), new Object[0]);
                Object[] objectArray = new Object[]{string, byArray2, new Integer(0), new Integer(byArray2.length), object};
                return (Class)defineClassProtectionDomain.invoke((Object)this, objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof ClassFormatError) {
                    throw (ClassFormatError)throwable;
                }
                throw new IOException(throwable.toString());
            }
            catch (Exception exception) {
                throw new IOException(exception.toString());
            }
        }
        return this.defineClass(string, byArray2, 0, byArray2.length);
    }

    public Class findClass(String string) throws ClassNotFoundException {
        this.project.log("Finding class " + string, 4);
        return this.findClass(string, this.classpath);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Class findClass(String string, Path path) throws ClassNotFoundException {
        InputStream inputStream = null;
        String string2 = this.getClassFilename(string);
        try {
            try {
                Serializable serializable;
                String[] stringArray = path.list();
                int n = 0;
                while (true) {
                    if (n >= stringArray.length || inputStream != null) {
                        if (inputStream != null) break;
                        throw new ClassNotFoundException();
                    }
                    serializable = this.project.resolveFile(stringArray[n]);
                    inputStream = this.getResourceStream((File)serializable, string2);
                    ++n;
                }
                serializable = this.getClassFromStream(inputStream, string);
                Object var9_9 = null;
                try {
                    if (inputStream == null) return serializable;
                    inputStream.close();
                    return serializable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return serializable;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw new ClassNotFoundException();
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {}
            catch (IOException iOException) {
                throw throwable;
            }
            if (inputStream == null) throw throwable;
            inputStream.close();
            throw throwable;
        }
    }

    private Class findBaseClass(String string) throws ClassNotFoundException {
        ClassLoader classLoader = (class$org$apache$tools$ant$AntClassLoader == null ? (class$org$apache$tools$ant$AntClassLoader = AntClassLoader.class$("org.apache.tools.ant.AntClassLoader")) : class$org$apache$tools$ant$AntClassLoader).getClassLoader();
        if (classLoader == null) {
            return this.findSystemClass(string);
        }
        return classLoader.loadClass(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            getProtectionDomain = (class$java$lang$Class == null ? (class$java$lang$Class = AntClassLoader.class$("java.lang.Class")) : class$java$lang$Class).getMethod("getProtectionDomain", new Class[0]);
            Class<?> clazz = Class.forName("java.security.ProtectionDomain");
            Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = AntClassLoader.class$("java.lang.String")) : class$java$lang$String, array$B == null ? (array$B = AntClassLoader.class$("[B")) : array$B, Integer.TYPE, Integer.TYPE, clazz};
            defineClassProtectionDomain = (class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = AntClassLoader.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader).getDeclaredMethod("defineClass", classArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

