/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.pool;

import java.security.SecureRandom;
import org.apache.avalon.excalibur.pool.Controller;
import org.apache.avalon.excalibur.pool.DefaultObjectFactory;
import org.apache.avalon.excalibur.pool.ObjectFactory;
import org.apache.avalon.excalibur.pool.Pool;
import org.apache.avalon.excalibur.pool.PoolManager;
import org.apache.avalon.excalibur.pool.VariableSizePool;

public class DefaultPoolManager
implements PoolManager {
    private final ObjectFactory m_controllerFactory;
    private final long m_managerKey;
    private final SecureRandom m_keyGenerator = new SecureRandom();

    public DefaultPoolManager(Class klass) throws Exception {
        this.m_managerKey = this.m_keyGenerator.nextLong();
        this.m_controllerFactory = new DefaultObjectFactory(klass, new Class[]{Long.TYPE}, new Object[]{new Long(this.m_managerKey)});
    }

    public Pool getManagedPool(ObjectFactory factory, int initialEntries) throws Exception {
        long poolKey = this.getKey();
        Controller controller = (Controller)this.m_controllerFactory.newInstance();
        controller.setKey(poolKey, this.m_managerKey);
        return new VariableSizePool(factory, initialEntries, poolKey);
    }

    private final long getKey() {
        return this.m_keyGenerator.nextLong();
    }
}

