/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.pipeline;

import org.apache.avalon.DefaultPipeline;
import org.apache.avalon.Loggable;
import org.apache.avalon.Stage;
import org.apache.avalon.camelot.AvalonEntry;
import org.apache.avalon.pipeline.AvalonStage;
import org.apache.log.Logger;

public class AvalonPipeline
extends DefaultPipeline
implements AvalonStage,
Loggable {
    protected boolean m_consumeException;
    protected Logger m_logger;

    public void setLogger(Logger logger) {
        this.m_logger = logger;
        int size = this.m_stages.size();
        int i = 0;
        while (i < size) {
            Object object = this.m_stages.get(i);
            if (object instanceof Loggable) {
                ((Loggable)object).setLogger(this.m_logger);
            }
            ++i;
        }
    }

    public void setConsumeException(boolean consumeException) {
        this.m_consumeException = consumeException;
    }

    public void addStage(Stage stage) {
        super.addStage(stage);
        if (stage instanceof Loggable) {
            ((Loggable)((Object)stage)).setLogger(this.m_logger);
        }
    }

    public void process(String name, AvalonEntry entry) throws Exception {
        int size = this.m_stages.size();
        int i = 0;
        while (i < size) {
            try {
                AvalonStage stage = (AvalonStage)this.m_stages.get(i);
                stage.process(name, entry);
            }
            catch (Exception e) {
                if (this.m_consumeException) {
                    this.m_logger.warn("Error processing " + name, e);
                }
                throw e;
            }
            ++i;
        }
    }
}

