/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log;

import org.apache.log.Category;
import org.apache.log.LogEntry;
import org.apache.log.LogKit;
import org.apache.log.LogTarget;
import org.apache.log.Priority;

public class Logger {
    protected static final long START_TIME = System.currentTimeMillis();
    protected final Logger m_parent;
    protected final Category m_category;
    protected LogTarget[] m_logTargets;

    public Logger(Category category) {
        this(category, null, null);
    }

    public Logger(Category category, LogTarget[] logTargetArray) {
        this(category, logTargetArray, null);
    }

    public Logger(Category category, LogTarget[] logTargetArray, Logger logger) {
        this.m_category = category;
        this.m_logTargets = logTargetArray;
        this.m_parent = logger;
    }

    public Logger(Category category, Logger logger) {
        this(category, null, logger);
    }

    public final void debug(String string, Throwable throwable) {
        if (this.m_category.getPriority().isLowerOrEqual(Priority.DEBUG) && LogKit.getGlobalPriority().isLowerOrEqual(Priority.DEBUG)) {
            this.output(Priority.DEBUG, string, throwable);
        }
    }

    public final void debug(String string) {
        if (this.m_category.getPriority().isLowerOrEqual(Priority.DEBUG) && LogKit.getGlobalPriority().isLowerOrEqual(Priority.DEBUG)) {
            this.output(Priority.DEBUG, string, null);
        }
    }

    public final void error(String string, Throwable throwable) {
        if (this.m_category.getPriority().isLowerOrEqual(Priority.ERROR) && LogKit.getGlobalPriority().isLowerOrEqual(Priority.ERROR)) {
            this.output(Priority.ERROR, string, throwable);
        }
    }

    public final void error(String string) {
        if (this.m_category.getPriority().isLowerOrEqual(Priority.ERROR) && LogKit.getGlobalPriority().isLowerOrEqual(Priority.ERROR)) {
            this.output(Priority.ERROR, string, null);
        }
    }

    public final void fatalError(String string, Throwable throwable) {
        if (this.m_category.getPriority().isLowerOrEqual(Priority.FATAL_ERROR) && LogKit.getGlobalPriority().isLowerOrEqual(Priority.FATAL_ERROR)) {
            this.output(Priority.FATAL_ERROR, string, throwable);
        }
    }

    public final void fatalError(String string) {
        if (this.m_category.getPriority().isLowerOrEqual(Priority.FATAL_ERROR) && LogKit.getGlobalPriority().isLowerOrEqual(Priority.FATAL_ERROR)) {
            this.output(Priority.FATAL_ERROR, string, null);
        }
    }

    public final Category getCategory() {
        return this.m_category;
    }

    public final void info(String string) {
        if (this.m_category.getPriority().isLowerOrEqual(Priority.INFO) && LogKit.getGlobalPriority().isLowerOrEqual(Priority.INFO)) {
            this.output(Priority.INFO, string, null);
        }
    }

    public final void log(Priority.Enum enum_, String string, Throwable throwable) {
        if (this.m_category.getPriority().isLowerOrEqual(enum_) && LogKit.getGlobalPriority().isLowerOrEqual(enum_)) {
            this.output(enum_, string, throwable);
        }
    }

    public final void log(Priority.Enum enum_, String string) {
        if (this.m_category.getPriority().isLowerOrEqual(enum_) && LogKit.getGlobalPriority().isLowerOrEqual(enum_)) {
            this.output(enum_, string, null);
        }
    }

    private final void output(Priority.Enum enum_, String string, Throwable throwable) {
        LogEntry logEntry = new LogEntry();
        logEntry.setCategory(this.m_category);
        logEntry.setContextStack(LogKit.getCurrentContext());
        if (null != string) {
            logEntry.setMessage(string);
        } else {
            logEntry.setMessage("");
        }
        logEntry.setThrowable(throwable);
        logEntry.setPriority(enum_);
        logEntry.setTime(System.currentTimeMillis() - START_TIME);
        this.output(logEntry);
    }

    protected final void output(LogEntry logEntry) {
        LogTarget[] logTargetArray = this.m_logTargets;
        if (null == logTargetArray) {
            if (null != this.m_parent) {
                this.m_parent.output(logEntry);
            } else {
                LogKit.getDefaultLogTarget().processEntry(logEntry);
            }
        } else {
            int n = 0;
            while (n < logTargetArray.length) {
                logTargetArray[n].processEntry(logEntry);
                ++n;
            }
        }
    }

    public final void warn(String string, Throwable throwable) {
        if (this.m_category.getPriority().isLowerOrEqual(Priority.WARN) && LogKit.getGlobalPriority().isLowerOrEqual(Priority.WARN)) {
            this.output(Priority.WARN, string, throwable);
        }
    }

    public final void warn(String string) {
        if (this.m_category.getPriority().isLowerOrEqual(Priority.WARN) && LogKit.getGlobalPriority().isLowerOrEqual(Priority.WARN)) {
            this.output(Priority.WARN, string, null);
        }
    }

    public void setLogTargets(LogTarget[] logTargetArray) {
        this.m_logTargets = logTargetArray;
    }

    public final LogTarget[] getLogTargets() {
        return this.m_logTargets;
    }

    public final void addLogTarget(LogTarget logTarget) {
        if (null == this.m_logTargets) {
            this.m_logTargets = new LogTarget[]{logTarget};
        } else {
            LogTarget[] logTargetArray = new LogTarget[this.m_logTargets.length + 1];
            System.arraycopy(this.m_logTargets, 0, logTargetArray, 0, this.m_logTargets.length);
            logTargetArray[this.m_logTargets.length] = logTarget;
            this.m_logTargets = logTargetArray;
        }
    }

    public Logger getChildLogger(String string) {
        String string2 = this.m_category.getName() + '.' + string;
        return LogKit.getLoggerFor(string2);
    }
}

