/*
 * Decompiled with CFR 0.152.
 */
package junit.swingui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

class ProgressBar
extends JPanel {
    boolean fError = false;
    int fTotal = 0;
    int fProgress = 0;
    int fProgressX = 0;

    public ProgressBar() {
        this.setBorder(BorderFactory.createBevelBorder(1));
    }

    private Color getStatusColor() {
        if (this.fError) {
            return Color.red;
        }
        return Color.green;
    }

    public void paintBackground(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    public void paintComponent(Graphics g) {
        this.paintBackground(g);
        this.paintStatus(g);
    }

    public void paintStatus(Graphics g) {
        g.setColor(this.getStatusColor());
        Rectangle r = new Rectangle(0, 0, this.fProgressX, this.getBounds().height);
        g.fillRect(1, 1, r.width - 1, r.height - 2);
    }

    private void paintStep(int startX, int endX) {
        this.repaint(startX, 1, endX - startX, this.getBounds().height - 2);
    }

    public void reset() {
        this.fProgressX = 1;
        this.fProgress = 0;
        this.fError = false;
        this.repaint();
    }

    public int scale(int value) {
        if (this.fTotal > 0) {
            return Math.max(1, value * (this.getBounds().width - 1) / this.fTotal);
        }
        return value;
    }

    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        this.fProgressX = this.scale(this.fProgress);
    }

    public void start(int total) {
        this.fTotal = total;
        this.reset();
    }

    public void step(boolean successful) {
        ++this.fProgress;
        int x = this.fProgressX;
        this.fProgressX = this.scale(this.fProgress);
        if (!this.fError && !successful) {
            this.fError = true;
            x = 1;
        }
        this.paintStep(x, this.fProgressX);
    }
}

