/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.monitor;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import org.apache.avalon.excalibur.monitor.StreamResource;
import org.apache.avalon.excalibur.source.Source;
import org.apache.avalon.excalibur.source.SourceValidity;

public final class SourceResource
extends StreamResource {
    private final Source source;
    private SourceValidity validity;

    public SourceResource(Source source) throws Exception {
        super(source.getSystemId());
        this.source = source;
        this.m_previousModified = System.currentTimeMillis();
        this.validity = source.getValidity();
    }

    public long lastModified() {
        if (this.validity == null) {
            return System.currentTimeMillis();
        }
        SourceValidity newVal = this.source.getValidity();
        if (newVal != null && this.validity.isValid(newVal)) {
            return this.m_previousModified;
        }
        this.validity = newVal;
        return System.currentTimeMillis();
    }

    public InputStream getResourceAsStream() throws IOException {
        return this.source.getInputStream();
    }

    public Reader getResourceAsReader() throws IOException {
        return new InputStreamReader(this.getResourceAsStream());
    }

    public OutputStream setResourceAsStream() throws IOException {
        throw new IOException("setResourceAsStream() not supported for URLResource");
    }

    public Writer setResourceAsWriter() throws IOException {
        throw new IOException("setResourceAsWriter() not supported for URLResource");
    }
}

