/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.i18n;

import java.util.Locale;
import org.apache.avalon.excalibur.pool.Poolable;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;

public class BundleInfo
implements Component,
Poolable,
Recyclable {
    public static final String ROLE = "org.apache.avalon.excalibur.i18n.BundleInfo";
    private String name;
    private Locale locale;
    private String ext;

    public void configure(String name, Locale locale, String ext) {
        this.name = name;
        this.locale = locale;
        this.ext = ext;
    }

    public void configure(String name, Locale locale) {
        this.configure(name, locale, null);
    }

    public void configure(Locale locale) {
        this.configure(null, locale);
    }

    public void configure(Configuration conf) {
        Locale locale = null;
        try {
            Configuration localeConf = conf.getChild("locale");
            locale = new Locale(localeConf.getAttribute("language"), localeConf.getAttribute("country"));
            locale = new Locale(localeConf.getAttribute("language"), localeConf.getAttribute("country"), localeConf.getAttribute("variant"));
        }
        catch (ConfigurationException e) {
            // empty catch block
        }
        String bundleName = null;
        try {
            bundleName = conf.getAttribute("name");
        }
        catch (ConfigurationException e) {
            // empty catch block
        }
        String ext = null;
        try {
            ext = conf.getAttribute("ext");
        }
        catch (ConfigurationException e) {
            // empty catch block
        }
        this.configure(bundleName, locale, ext);
    }

    public String getName() {
        return this.name;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getExtensionParameter() {
        return this.ext;
    }

    public String toString() {
        return "BundleInfo(" + this.name + "," + this.locale + "," + this.ext + ")";
    }

    public BundleInfo getParent() {
        if (this.locale != null && !this.locale.getLanguage().equals("")) {
            BundleInfo bi = new BundleInfo();
            bi.configure(this.name, this.getParentLocale(), this.ext);
            return bi;
        }
        return null;
    }

    protected Locale getParentLocale() {
        Locale newloc = this.locale.getVariant().equals("") ? (this.locale.getCountry().equals("") ? new Locale("", "", "") : new Locale(this.locale.getLanguage(), "", "")) : new Locale(this.locale.getLanguage(), this.locale.getCountry(), "");
        return newloc;
    }

    public boolean matches(BundleInfo info) {
        return this.match(this.name, info.getName()) && this.match(this.locale, info.getLocale()) && this.match(this.ext, info.getExtensionParameter());
    }

    protected boolean match(String str, String reference) {
        if (str == null) {
            return true;
        }
        if (reference == null) {
            return false;
        }
        return str.equals(reference);
    }

    protected boolean match(Locale locale, Locale reference) {
        if (locale == null) {
            return true;
        }
        if (reference == null) {
            return false;
        }
        return this.match(locale.getLanguage(), reference.getLanguage()) && this.match(locale.getCountry(), reference.getCountry()) && this.match(locale.getVariant(), reference.getVariant());
    }

    public void recycle() {
        this.name = null;
        this.locale = null;
        this.ext = null;
    }
}

