/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.logger.factory;

import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;
import javax.jms.Topic;
import javax.jms.TopicConnectionFactory;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.apache.avalon.excalibur.logger.LogTargetFactory;
import org.apache.avalon.excalibur.logger.factory.FormatterFactory;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.log.LogTarget;
import org.apache.log.format.Formatter;
import org.apache.log.output.jms.JMSQueueTarget;
import org.apache.log.output.jms.JMSTopicTarget;
import org.apache.log.output.jms.MessageBuilder;
import org.apache.log.output.jms.ObjectMessageBuilder;
import org.apache.log.output.jms.PropertyInfo;
import org.apache.log.output.jms.PropertyType;
import org.apache.log.output.jms.TextMessageBuilder;

public class JMSTargetFactory
implements LogTargetFactory {
    /*
     * WARNING - void declaration
     */
    public LogTarget createTarget(Configuration configuration) throws ConfigurationException {
        JMSTopicTarget logTarget;
        void destination;
        ConnectionFactory factory;
        String factoryName = configuration.getChild("connection-factory", true).getValue();
        Configuration destinationConf = configuration.getChild("destination", true);
        String destinationName = destinationConf.getValue();
        String destinationType = destinationConf.getAttribute("type", "topic");
        Configuration messageConf = configuration.getChild("message", true);
        MessageBuilder messageBuilder = this.getMessageBuilder(messageConf);
        try {
            InitialContext ctx = new InitialContext();
            factory = (ConnectionFactory)ctx.lookup(factoryName);
            Destination destination2 = (Destination)ctx.lookup(destinationName);
        }
        catch (NameNotFoundException nnfe) {
            throw new ConfigurationException("Cannot lookup object", (Throwable)nnfe);
        }
        catch (NamingException ne) {
            throw new ConfigurationException("Cannot get naming context", (Throwable)ne);
        }
        if ("queue".equals(destinationType)) {
            JMSQueueTarget jMSQueueTarget = new JMSQueueTarget(messageBuilder, (QueueConnectionFactory)factory, (Queue)destination);
        } else {
            logTarget = new JMSTopicTarget(messageBuilder, (TopicConnectionFactory)factory, (Topic)destination);
        }
        return logTarget;
    }

    private final MessageBuilder getMessageBuilder(Configuration configuration) throws ConfigurationException {
        String messageType = configuration.getAttribute("type", "object");
        if ("text".equals(messageType)) {
            Formatter formatter;
            Configuration[] propertyConf = configuration.getChild("property", true).getChildren();
            Configuration formatterConf = configuration.getChild("format");
            PropertyInfo[] properties = new PropertyInfo[propertyConf.length];
            int i2 = 0;
            while (i2 < properties.length) {
                String name = propertyConf[i2].getValue();
                int type = PropertyType.getTypeIdFor((String)propertyConf[i2].getName());
                String aux = propertyConf[i2].getAttribute("aux", null);
                properties[i2] = new PropertyInfo(name, type, aux);
                ++i2;
            }
            if (formatterConf != null) {
                FormatterFactory formatterFactory = new FormatterFactory();
                Formatter i2 = formatterFactory.createFormatter(formatterConf);
            } else {
                formatter = null;
            }
            return new TextMessageBuilder(properties, formatter);
        }
        return new ObjectMessageBuilder();
    }
}

