/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.framework.configuration;

import java.util.ArrayList;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class SAXConfigurationHandler
extends DefaultHandler
implements ErrorHandler {
    protected final ArrayList m_elements = new ArrayList();
    protected Configuration m_configuration;
    protected Locator m_locator;

    public Configuration getConfiguration() {
        return this.m_configuration;
    }

    public void clear() {
        this.m_elements.clear();
        this.m_locator = null;
    }

    public void setDocumentLocator(Locator locator) {
        this.m_locator = locator;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        String string = new String(cArray, n, n2).trim();
        if (string.equals("")) {
            return;
        }
        DefaultConfiguration defaultConfiguration = (DefaultConfiguration)this.m_elements.get(this.m_elements.size() - 1);
        if (0 != defaultConfiguration.getChildCount()) {
            throw new SAXException("Not allowed to define mixed content in the element " + defaultConfiguration.getName() + " at " + defaultConfiguration.getLocation());
        }
        string = defaultConfiguration.getValue("") + string;
        defaultConfiguration.setValue(string);
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        int n = this.m_elements.size() - 1;
        Object e = this.m_elements.remove(n);
        if (0 == n) {
            this.m_configuration = (Configuration)e;
        }
    }

    protected DefaultConfiguration createConfiguration(String string, String string2) {
        return new DefaultConfiguration(string, string2);
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        DefaultConfiguration defaultConfiguration = this.createConfiguration(string2, this.getLocationString());
        int n = this.m_elements.size() - 1;
        if (n > -1) {
            DefaultConfiguration defaultConfiguration2 = (DefaultConfiguration)this.m_elements.get(n);
            if (null != defaultConfiguration2.getValue(null)) {
                throw new SAXException("Not allowed to define mixed content in the element " + defaultConfiguration2.getName() + " at " + defaultConfiguration2.getLocation());
            }
            defaultConfiguration2.addChild(defaultConfiguration);
        }
        this.m_elements.add(defaultConfiguration);
        int n2 = attributes.getLength();
        int n3 = 0;
        while (n3 < n2) {
            String string4 = attributes.getQName(n3);
            String string5 = attributes.getValue(n3);
            defaultConfiguration.setAttribute(string4, string5);
            ++n3;
        }
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    protected String getLocationString() {
        if (null == this.m_locator) {
            return "Unknown";
        }
        return this.m_locator.getSystemId() + ":" + this.m_locator.getLineNumber() + ":" + this.m_locator.getColumnNumber();
    }
}

