/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.framework;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.avalon.framework.CascadingThrowable;

public final class ExceptionUtil {
    private ExceptionUtil() {
    }

    public static String printStackTrace(Throwable throwable) {
        return ExceptionUtil.printStackTrace(throwable, 0, true);
    }

    public static String printStackTrace(Throwable throwable, boolean bl) {
        return ExceptionUtil.printStackTrace(throwable, 0, bl);
    }

    public static String printStackTrace(Throwable throwable, int n) {
        String[] stringArray = ExceptionUtil.captureStackTrace(throwable);
        if (0 == n || n > stringArray.length) {
            n = stringArray.length;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(stringArray[n2]);
            stringBuffer.append('\n');
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String printStackTrace(Throwable throwable, int n, boolean bl) {
        String string = ExceptionUtil.printStackTrace(throwable, n);
        if (!bl || !(throwable instanceof CascadingThrowable)) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        throwable = ((CascadingThrowable)((Object)throwable)).getCause();
        while (null != throwable) {
            stringBuffer.append("rethrown from\n");
            stringBuffer.append(ExceptionUtil.printStackTrace(throwable, n));
            throwable = throwable instanceof CascadingThrowable ? ((CascadingThrowable)((Object)throwable)).getCause() : null;
        }
        return stringBuffer.toString();
    }

    public static String[] captureStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter((Writer)stringWriter, true));
        return ExceptionUtil.splitString(stringWriter.toString(), "\n");
    }

    public static String[] splitString(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList.toArray(new String[0]);
    }
}

