/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.framework.camelot;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import org.apache.avalon.excalibur.io.ExtensionFileFilter;
import org.apache.avalon.framework.camelot.Deployer;
import org.apache.avalon.framework.camelot.DeploymentException;

public final class CamelotUtil {
    public static void deployFromDirectory(Deployer deployer, File file, String string) throws DeploymentException {
        CamelotUtil.deployFromDirectory(deployer, file, new String[]{string});
    }

    public static void deployFromDirectory(Deployer deployer, File file, String[] stringArray) throws DeploymentException {
        ExtensionFileFilter extensionFileFilter = new ExtensionFileFilter(stringArray);
        CamelotUtil.deployFromDirectory(deployer, file, (FilenameFilter)extensionFileFilter);
    }

    public static void deployFromDirectory(Deployer deployer, File file, FilenameFilter filenameFilter) throws DeploymentException {
        File[] fileArray = file.listFiles(filenameFilter);
        if (fileArray != null) {
            CamelotUtil.deployFiles(deployer, fileArray);
        }
    }

    public static void deployFiles(Deployer deployer, File[] fileArray) throws DeploymentException {
        int n = 0;
        while (n < fileArray.length) {
            String string = fileArray[n].getName();
            int n2 = string.lastIndexOf(46);
            if (-1 == n2) {
                n2 = string.length();
            }
            String string2 = string.substring(0, n2);
            try {
                File file = fileArray[n].getCanonicalFile();
                deployer.deploy(string2, file.toURL());
            }
            catch (MalformedURLException malformedURLException) {
                throw new DeploymentException("Malformed URL for " + fileArray[n], malformedURLException);
            }
            catch (IOException iOException) {
                throw new DeploymentException("Unable to get canonical representation for file " + fileArray[n], iOException);
            }
            ++n;
        }
    }

    private CamelotUtil() {
    }
}

