/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.framework.atlantis;

import java.util.Iterator;
import org.apache.avalon.framework.atlantis.Application;
import org.apache.avalon.framework.atlantis.Kernel;
import org.apache.avalon.framework.camelot.AbstractContainer;
import org.apache.avalon.framework.camelot.ContainerException;
import org.apache.avalon.framework.camelot.Entry;

public abstract class AbstractKernel
extends AbstractContainer
implements Kernel {
    protected boolean m_initialised;

    public void initialize() throws Exception {
        Iterator iterator = this.list();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Entry entry = this.getEntry(string);
            this.initializeEntry(string, entry);
        }
    }

    public void start() throws Exception {
        Iterator iterator = this.list();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Entry entry = this.getEntry(string);
            this.startEntry(string, entry);
        }
    }

    public void stop() throws Exception {
        Iterator iterator = this.list();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Entry entry = this.getEntry(string);
            this.stopEntry(string, entry);
        }
    }

    public void dispose() throws Exception {
        this.m_initialised = false;
        Iterator iterator = this.list();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Entry entry = this.getEntry(string);
            this.disposeEntry(string, entry);
        }
    }

    public Application getApplication(String string) throws ContainerException {
        Entry entry = this.getEntry(string);
        this.initializeEntry(string, entry);
        return (Application)entry.getInstance();
    }

    private void initializeEntry(String string, Entry entry) throws ContainerException {
        Application application = (Application)entry.getInstance();
        if (application == null) {
            this.preInitializeEntry(string, entry);
            application = this.createApplicationFor(string, entry);
            try {
                entry.setInstance(application);
                this.prepareApplication(string, entry);
                application.initialize();
            }
            catch (Throwable throwable) {
                entry.setInstance(null);
                throw new ContainerException("Failed to initialize application", throwable);
            }
            this.postInitializeEntry(string, entry);
        }
    }

    private void startEntry(String string, Entry entry) throws Exception {
        Application application = (Application)entry.getInstance();
        if (application != null) {
            application.start();
        } else {
            this.getLogger().warn("Failed to start application " + string + " as it is not initialized");
        }
    }

    private void stopEntry(String string, Entry entry) throws Exception {
        Application application = (Application)entry.getInstance();
        if (application != null) {
            application.stop();
        } else {
            this.getLogger().warn("Failed to stop application " + string + " as it is not initialized/started");
        }
    }

    private void disposeEntry(String string, Entry entry) throws ContainerException {
        Application application = (Application)entry.getInstance();
        if (application != null) {
            this.preDisposeEntry(string, entry);
            entry.setInstance(null);
            try {
                application.dispose();
            }
            catch (Exception exception) {
                throw new ContainerException("Failed to dispose application " + string, exception);
            }
            this.postDisposeEntry(string, entry);
        }
    }

    protected void preInitializeEntry(String string, Entry entry) throws ContainerException {
    }

    protected void postInitializeEntry(String string, Entry entry) {
    }

    protected void preDisposeEntry(String string, Entry entry) throws ContainerException {
    }

    protected void postDisposeEntry(String string, Entry entry) {
    }

    protected void prepareApplication(String string, Entry entry) throws ContainerException {
    }

    protected abstract Application createApplicationFor(String var1, Entry var2) throws ContainerException;
}

