/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.vfs;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.avalon.excalibur.vfs.VFile;
import org.apache.avalon.excalibur.vfs.VFileAccessor;

public final class DirectoryVFileAccessor
implements VFileAccessor {
    public long getSize(VFile file, Object resource) {
        try {
            File realFile = this.getFile(file, resource);
            return realFile.length();
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public InputStream getInputStream(VFile file, Object resource) {
        try {
            File realFile = this.getFile(file, resource);
            return new FileInputStream(realFile);
        }
        catch (Exception e) {
            return null;
        }
    }

    private File getFile(VFile file, Object resource) {
        File baseFile = (File)resource;
        String name = file.toString().substring(1).replace('/', File.separatorChar);
        return new File(baseFile, name);
    }
}

