/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.pool;

import org.apache.avalon.excalibur.collections.Buffer;
import org.apache.avalon.excalibur.collections.FixedSizeBuffer;
import org.apache.avalon.excalibur.concurrent.Mutex;
import org.apache.avalon.excalibur.pool.ObjectFactory;
import org.apache.avalon.excalibur.pool.Pool;
import org.apache.avalon.excalibur.pool.Poolable;
import org.apache.avalon.framework.activity.Disposable;

public final class FixedSizePool
implements Pool,
Disposable {
    private boolean m_disposed = false;
    private final Buffer m_buffer;
    private final ObjectFactory m_factory;
    private final Mutex m_mutex = new Mutex();

    public FixedSizePool(ObjectFactory factory, int size) throws Exception {
        this.m_buffer = new FixedSizeBuffer(size);
        this.m_factory = factory;
        int i = 0;
        while (i < size) {
            this.m_buffer.add(this.m_factory.newInstance());
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Poolable get() {
        if (this.m_disposed) {
            throw new IllegalStateException("Cannot get an object from a disposed pool");
        }
        Poolable object = null;
        try {
            try {
                this.m_mutex.acquire();
                object = (Poolable)this.m_buffer.remove();
            }
            catch (InterruptedException ie) {
                Object var4_3 = null;
                this.m_mutex.release();
                return object;
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.m_mutex.release();
            throw throwable;
        }
        this.m_mutex.release();
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void put(Poolable object) {
        if (this.m_disposed) {
            try {
                this.m_factory.decommission((Object)object);
                return;
            }
            catch (Exception e) {
                return;
            }
        }
        try {
            try {
                this.m_mutex.acquire();
                this.m_buffer.add((Object)object);
            }
            catch (InterruptedException e) {
                Object var4_5 = null;
                this.m_mutex.release();
                return;
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.m_mutex.release();
            throw throwable;
        }
        this.m_mutex.release();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dispose() {
        this.m_disposed = true;
        try {
            try {
                this.m_mutex.acquire();
                while (!this.m_buffer.isEmpty()) {
                    try {
                        this.m_factory.decommission(this.m_buffer.remove());
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            catch (InterruptedException ie) {
                Object var3_4 = null;
                this.m_mutex.release();
                return;
            }
            Object var3_3 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.m_mutex.release();
            throw throwable;
        }
        this.m_mutex.release();
    }
}

