/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.i18n;

import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.avalon.excalibur.i18n.AbstractBundle;
import org.apache.avalon.excalibur.xml.xpath.XPathProcessor;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlBundle
extends AbstractBundle
implements Disposable,
Composable {
    private Map cache = new HashMap();
    private Map cacheNotFound = new HashMap();
    private Document doc;
    protected ComponentManager manager = null;
    private XPathProcessor processor = null;
    private boolean loadOnInit = true;
    private boolean useRootElement = false;
    static /* synthetic */ Class class$org$apache$avalon$excalibur$i18n$XmlBundle;

    public void compose(ComponentManager manager) {
        this.manager = manager;
        try {
            this.processor = (XPathProcessor)this.manager.lookup("org.apache.avalon.excalibur.xml.xpath.XPathProcessor");
        }
        catch (Exception e) {
            this.getLogger().error("cannot obtain XPathProcessor", (Throwable)e);
        }
    }

    public void setLoadOnInit(boolean loadOnInit) {
        this.loadOnInit = loadOnInit;
    }

    public void setUseRootElement(boolean useRootElement) {
        this.useRootElement = useRootElement;
    }

    public void init(String uri) throws Exception {
        this.init(this.getDocumentBuilder().parse(uri));
    }

    public void init(File file) throws Exception {
        this.init(this.getDocumentBuilder().parse(file));
    }

    public void init(InputStream inStream) throws Exception {
        this.init(this.getDocumentBuilder().parse(inStream));
    }

    public void init(Document document) {
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("constructing XMLResourceBundle: " + this.getBundleInfo());
        }
        this.doc = document;
        if (this.loadOnInit) {
            this.cacheAll(this.doc.getDocumentElement(), this.useRootElement ? '/' + this.doc.getDocumentElement().getTagName() : "");
        }
    }

    protected DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        return factory.newDocumentBuilder();
    }

    public String convertKey(String userKey) {
        return '/' + userKey.replace('.', '/');
    }

    public Document getDocument() {
        return this.doc;
    }

    protected boolean cacheContains(String key) {
        boolean result = this.cache.containsKey(key);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug(this.getBundleInfo() + ": cache contains key '" + key + "': " + result);
        }
        return result;
    }

    protected boolean cacheNotFoundContains(String key) {
        boolean result = this.cacheNotFound.containsKey(key);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug(this.getBundleInfo() + ": cache_not_found contains key '" + key + "': " + result);
        }
        return result;
    }

    protected void cacheKey(String key, String value) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug(this.getBundleInfo() + ": caching: " + key + " = " + value);
        }
        this.cache.put(key, value);
    }

    protected void cacheNotFoundKey(String key) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug(this.getBundleInfo() + ": caching not_found: " + key);
        }
        this.cacheNotFound.put(key, "");
    }

    protected String getFromCache(String key) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug(this.getBundleInfo() + ": returning from cache: " + key);
        }
        return (String)this.cache.get(key);
    }

    protected void cacheAll(Node parent, String pathToParent) {
        NodeList children = parent.getChildNodes();
        int childnum = children.getLength();
        int i = 0;
        while (i < childnum) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                String childValue;
                StringBuffer pathToChild = new StringBuffer(pathToParent).append('/').append(child.getNodeName());
                NamedNodeMap attrs = child.getAttributes();
                if (attrs != null) {
                    Node temp = null;
                    Object pathToAttr = null;
                    int attrnum = attrs.getLength();
                    int j = 0;
                    while (j < attrnum) {
                        temp = attrs.item(j);
                        if (!temp.getNodeName().equalsIgnoreCase("xml:lang")) {
                            pathToChild.append("[@").append(temp.getNodeName()).append("='").append(temp.getNodeValue()).append("']");
                        }
                        ++j;
                    }
                }
                if ((childValue = XmlBundle.getTextValue(child)) != null) {
                    this.cacheKey(pathToChild.toString(), childValue);
                } else {
                    this.cacheAll(child, pathToChild.toString());
                }
            }
            ++i;
        }
    }

    public String getString(String key) throws MissingResourceException {
        String value = this._getString(this.convertKey(key));
        if (value == null) {
            throw new MissingResourceException("Unable to locate resource: " + key, (class$org$apache$avalon$excalibur$i18n$XmlBundle == null ? (class$org$apache$avalon$excalibur$i18n$XmlBundle = XmlBundle.class$("org.apache.avalon.excalibur.i18n.XmlBundle")) : class$org$apache$avalon$excalibur$i18n$XmlBundle).getName(), key);
        }
        return value;
    }

    protected String _getString(String key) {
        if (key == null) {
            return null;
        }
        String value = this.getFromCache(key);
        if (value == null && !this.cacheNotFoundContains(key)) {
            if (this.doc != null) {
                value = this._getString(this.doc.getDocumentElement(), key);
            }
            if (value == null && this.getParent() != null) {
                value = this.getParent().getString(key);
            }
            if (value != null) {
                this.cacheKey(key, value);
            } else {
                this.cacheNotFoundKey(key);
            }
        }
        return value;
    }

    protected String _getString(Node node, String key) {
        String value = null;
        try {
            value = XmlBundle.getTextValue(this._getNode(node, key));
        }
        catch (Exception e) {
            this.getLogger().error(this.getBundleInfo() + ": error while locating resource: " + key, (Throwable)e);
        }
        return value;
    }

    protected static String getTextValue(Node element) {
        if (element == null) {
            return null;
        }
        NodeList list = element.getChildNodes();
        int listsize = list.getLength();
        Node item = null;
        String itemValue = null;
        int i = 0;
        if (i < listsize) {
            item = list.item(i);
            if (item.getNodeType() != 3) {
                return null;
            }
            itemValue = item.getNodeValue();
            if (itemValue == null) {
                return null;
            }
            if ((itemValue = itemValue.trim()).length() == 0) {
                return null;
            }
            return itemValue;
        }
        return null;
    }

    protected Node _getNode(String key) {
        return this._getNode(this.doc.getDocumentElement(), key);
    }

    protected Node _getNode(Node rootNode, String key) {
        Node node = null;
        try {
            node = this.processor.selectSingleNode(rootNode, key);
        }
        catch (Exception e) {
            this.getLogger().error("Error while locating resource with key: " + key, (Throwable)e);
        }
        return node;
    }

    public void dispose() {
        this.manager.release((Component)this.processor);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

