/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.event;

import org.apache.avalon.excalibur.event.PreparedEnqueue;
import org.apache.avalon.excalibur.event.Queue;
import org.apache.avalon.excalibur.event.QueueElement;
import org.apache.avalon.excalibur.event.SourceException;

public abstract class AbstractQueue
implements Queue {
    protected long m_timeout = 0L;

    public int canAccept() {
        return this.maxSize() > 0 ? this.maxSize() - this.size() : this.maxSize();
    }

    public int maxSize() {
        return -1;
    }

    public boolean isFull() {
        return this.maxSize() - this.size() > 0;
    }

    public void setTimeOut(long millis) {
        this.m_timeout = millis > 0L ? millis : 0L;
    }

    protected void block(Object lock) {
        if (this.m_timeout > 0L) {
            long start = System.currentTimeMillis();
            long end = start + this.m_timeout;
            while (start < end || this.size() > 0) {
                try {
                    lock.wait(this.m_timeout);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
        }
    }

    public abstract int size();

    public abstract PreparedEnqueue prepareEnqueue(QueueElement[] var1) throws SourceException;

    public abstract boolean tryEnqueue(QueueElement var1);

    public abstract void enqueue(QueueElement[] var1) throws SourceException;

    public abstract void enqueue(QueueElement var1) throws SourceException;

    public abstract QueueElement[] dequeue(int var1);

    public abstract QueueElement[] dequeueAll();

    public abstract QueueElement dequeue();
}

