/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.dvsl;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.dvsl.DVSL;

public class DVSLTask1
extends MatchingTask {
    protected File basedir;
    protected File destdir;
    protected String stylesheet;
    protected String toolboxProps;
    protected String extension = ".html";
    protected String velPropClass = null;
    private Path classpath = null;

    public void setBasedir(File bd) {
        this.basedir = bd;
    }

    public void setDestdir(File dd) {
        this.destdir = dd;
    }

    public void setStyle(String style) {
        this.stylesheet = style;
    }

    public void setExtension(String ext) {
        this.extension = ext;
    }

    public void setToolbox(String toolbox) {
        this.toolboxProps = toolbox;
    }

    public void setVelocityConfigClass(String classname) {
        this.velPropClass = classname;
    }

    public void setClasspath(Path classpath) {
        this.createClasspath().append(classpath);
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(((ProjectComponent)this).project);
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public void execute() throws BuildException {
        if (this.basedir == null) {
            this.basedir = ((ProjectComponent)this).project.resolveFile(".");
        }
        if (this.destdir == null) {
            this.destdir = ((ProjectComponent)this).project.resolveFile(".");
        }
        if (this.stylesheet == null) {
            throw new BuildException("You must specify a stylesheet (.vsl file) with the style parameter");
        }
        this.process();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void process() throws BuildException {
        DVSL dvsl = new DVSL();
        if (this.velPropClass != null) {
            Object ob = null;
            try {
                ob = Class.forName(this.velPropClass).newInstance();
            }
            catch (Exception ex) {
                throw new BuildException("Error instantiating VelocityPropClass : " + ex);
            }
            if (ob instanceof Map) {
                dvsl.setVelocityConfig(ob);
            }
        }
        try {
            dvsl.setStylesheet(this.stylesheet);
        }
        catch (Exception e) {
            throw new BuildException("Problem setting stylesheet : " + e);
        }
        if (this.toolboxProps != null) {
            try {
                Properties p = new Properties();
                p.load(new FileInputStream(((ProjectComponent)this).project.resolveFile(this.toolboxProps)));
                dvsl.setToolbox(p);
            }
            catch (Exception ee) {
                throw new BuildException("Error loading the toolbox : " + ee);
            }
        }
        String[] infiles = this.getDirectoryScanner(this.basedir).getIncludedFiles();
        int i = 0;
        while (true) {
            block18: {
                Exception ee2;
                Object var13_15;
                if (i >= infiles.length) {
                    this.log("Processing complete.");
                    return;
                }
                String infilename = infiles[i];
                String root = infilename.substring(0, infilename.lastIndexOf(46));
                String outfilename = root + this.extension;
                Writer writer = null;
                try {
                    try {
                        File infile = new File(this.basedir, infilename);
                        File outfile = new File(this.destdir, outfilename);
                        writer = new BufferedWriter(new FileWriter(outfile));
                        long time = dvsl.transform(infile, writer);
                        this.log("Processed " + infilename + " to " + outfilename + " in " + time + " msec.");
                    }
                    catch (Exception e) {
                        throw new BuildException("Exception while procesing " + infilename + " : " + e);
                    }
                    var13_15 = null;
                    if (writer == null) break block18;
                }
                catch (Throwable throwable) {
                    var13_15 = null;
                    if (writer == null) throw throwable;
                    try {
                        writer.flush();
                        writer.close();
                        throw throwable;
                    }
                    catch (Exception ee2) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {}
                catch (Exception ee2) {}
                writer.flush();
                writer.close();
            }
            ++i;
        }
    }
}

