/*
 * Decompiled with CFR 0.152.
 */
package junit.framework;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Vector;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;

public class TestSuite
implements Test {
    private Vector fTests = new Vector(10);
    private String fName;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$0;

    public TestSuite() {
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TestSuite(Class theClass) {
        Class clazz;
        this.fName = theClass.getName();
        Constructor constructor = this.getConstructor(theClass);
        if (!Modifier.isPublic(theClass.getModifiers())) {
            this.addTest(this.warning("Class " + theClass.getName() + " is not public"));
            return;
        }
        if (constructor == null) {
            this.addTest(this.warning("Class " + theClass.getName() + " has no public constructor TestCase(String name)"));
            return;
        }
        Class superClass = theClass;
        Vector names = new Vector();
        boolean bl = true;
        do {
            if (!bl || (bl = false) || !true) {
                Method[] methods = superClass.getDeclaredMethods();
                int i = 0;
                while (i < methods.length) {
                    this.addTestMethod(methods[i], names, constructor);
                    ++i;
                }
                superClass = superClass.getSuperclass();
            }
            if ((clazz = class$0) != null) continue;
            try {
                clazz = Class.forName("junit.framework.Test");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        } while (clazz.isAssignableFrom(superClass));
        if (this.fTests.size() == 0) {
            this.addTest(this.warning("No tests found in " + theClass.getName()));
        }
    }

    public TestSuite(String name) {
        this.fName = name;
    }

    public void addTest(Test test) {
        this.fTests.addElement(test);
    }

    private void addTestMethod(Method m, Vector names, Constructor constructor) {
        String name = m.getName();
        if (names.contains(name)) {
            return;
        }
        if (this.isPublicTestMethod(m)) {
            names.addElement(name);
            Object[] args = new Object[]{name};
            try {
                this.addTest((Test)constructor.newInstance(args));
            }
            catch (Exception t) {
                this.addTest(this.warning("Cannot instantiate test case: " + name));
            }
        } else if (this.isTestMethod(m)) {
            this.addTest(this.warning("Test method isn't public: " + m.getName()));
        }
    }

    public int countTestCases() {
        int count = 0;
        Enumeration e = this.tests();
        while (e.hasMoreElements()) {
            Test test = (Test)e.nextElement();
            count += test.countTestCases();
        }
        return count;
    }

    private Constructor getConstructor(Class theClass) {
        Class[] classArray = new Class[1];
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class[] args = classArray;
        Constructor c = null;
        try {
            c = theClass.getConstructor(args);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return c;
    }

    private boolean isPublicTestMethod(Method m) {
        return this.isTestMethod(m) && Modifier.isPublic(m.getModifiers());
    }

    private boolean isTestMethod(Method m) {
        String name = m.getName();
        Class<?>[] parameters = m.getParameterTypes();
        Class<?> returnType = m.getReturnType();
        return parameters.length == 0 && name.startsWith("test") && returnType.equals(Void.TYPE);
    }

    public void run(TestResult result) {
        Enumeration e = this.tests();
        while (e.hasMoreElements()) {
            if (result.shouldStop()) break;
            Test test = (Test)e.nextElement();
            test.run(result);
        }
    }

    public Test testAt(int index) {
        return (Test)this.fTests.elementAt(index);
    }

    public int testCount() {
        return this.fTests.size();
    }

    public Enumeration tests() {
        return this.fTests.elements();
    }

    public String toString() {
        if (this.fName != null) {
            return this.fName;
        }
        return super.toString();
    }

    private Test warning(final String message) {
        return new TestCase("warning"){

            protected final void runTest() {
                Assert.fail(message);
            }
        };
    }
}

