/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class Taskdef
extends Task {
    private String name;
    private String value;
    private Path classpath;

    public void setClasspath(Path path) {
        if (this.classpath == null) {
            this.classpath = path;
        } else {
            this.classpath.append(path);
        }
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.project);
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference reference) {
        this.createClasspath().setRefid(reference);
    }

    public void execute() throws BuildException {
        if (this.name == null || this.value == null) {
            String string = "name or classname attributes of taskdef element are undefined";
            throw new BuildException(string);
        }
        try {
            Class<?> clazz;
            Object object = null;
            if (this.classpath != null) {
                clazz = new AntClassLoader(this.project, this.classpath, false);
                ((AntClassLoader)((Object)clazz)).addSystemPackageRoot("org.apache.tools.ant");
                object = clazz;
            } else {
                object = this.getClass().getClassLoader();
            }
            clazz = null;
            if (object != null) {
                clazz = ((ClassLoader)object).loadClass(this.value);
                AntClassLoader.initializeClass(clazz);
            } else {
                clazz = Class.forName(this.value);
            }
            this.project.addTaskDefinition(this.name, clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            String string = "taskdef class " + this.value + " cannot be found";
            throw new BuildException(string, classNotFoundException, this.location);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            String string = "taskdef class " + this.value + " cannot be found";
            throw new BuildException(string, noClassDefFoundError, this.location);
        }
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getClassname() {
        return this.value;
    }

    public void setClassname(String string) {
        this.value = string;
    }
}

