/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.templates;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xalan.serialize.Encodings;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.templates.StylesheetRoot;
import org.apache.xml.utils.FastStringBuffer;
import org.apache.xml.utils.QName;
import org.apache.xml.utils.WrappedRuntimeException;

public class OutputProperties
extends ElemTemplateElement
implements Cloneable {
    static final String S_XSLT_PREFIX = "xslt.output.";
    static final int S_XSLT_PREFIX_LEN = "xslt.output.".length();
    static final String S_XALAN_PREFIX = "org.apache.xslt.";
    static final int S_XALAN_PREFIX_LEN = "org.apache.xslt.".length();
    static final String S_BUILTIN_EXTENSIONS_UNIVERSAL = "{http://xml.apache.org/xslt}";
    private transient Hashtable m_propertiesLevels;
    private Properties m_properties = null;
    public static String S_KEY_INDENT_AMOUNT = "{http://xml.apache.org/xslt}indent-amount";
    public static String S_KEY_CONTENT_HANDLER = "{http://xml.apache.org/xslt}content-handler";
    public static String S_KEY_ENTITIES = "{http://xml.apache.org/xslt}entities";
    public static String S_USE_URL_ESCAPING = "{http://xml.apache.org/xslt}use-url-escaping";
    private static Properties m_xml_properties = null;
    private static Properties m_html_properties = null;
    private static Properties m_text_properties = null;
    private static Integer m_synch_object = new Integer(1);
    static /* synthetic */ Class class$org$apache$xalan$templates$OutputProperties;

    public OutputProperties() {
        this("xml");
    }

    public OutputProperties(String string) {
        this.m_properties = new Properties(OutputProperties.getDefaultMethodProperties(string));
    }

    public OutputProperties(Properties properties) {
        this.m_properties = new Properties(properties);
    }

    private void checkDuplicates(OutputProperties outputProperties) throws TransformerException {
        if (this.m_propertiesLevels == null) {
            this.m_propertiesLevels = new Hashtable();
        }
        int n = outputProperties.getStylesheetComposed().getImportCountComposed();
        Properties properties = outputProperties.getProperties();
        Enumeration enumeration = ((Hashtable)properties).keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.equals("cdata-section-elements")) continue;
            Integer n2 = (Integer)this.m_propertiesLevels.get(string);
            if (n2 == null) {
                this.m_propertiesLevels.put(string, new Integer(n));
                continue;
            }
            if (n < n2) continue;
            String string2 = (String)((Hashtable)this.m_properties).get(string);
            String string3 = (String)((Hashtable)outputProperties.m_properties).get(string);
            if ((string2 != null || string3 == null) && string2.equals(string3)) continue;
            String string4 = String.valueOf(string) + " can not be multiply defined at the same " + "import level! Old value = " + string2 + "; New value = " + string3;
            throw new TransformerException(string4, outputProperties);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public Object clone() {
        try {
            OutputProperties outputProperties = (OutputProperties)super.clone();
            outputProperties.m_properties = (Properties)((Hashtable)outputProperties.m_properties).clone();
            return outputProperties;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void compose() throws TransformerException {
        super.compose();
        this.m_propertiesLevels = null;
    }

    public void copyFrom(Properties properties) {
        this.copyFrom(properties, true);
    }

    public void copyFrom(Properties properties, boolean bl) {
        Enumeration enumeration = ((Hashtable)properties).keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object v = ((Hashtable)this.m_properties).get(string);
            if (v == null) {
                String string2 = (String)((Hashtable)properties).get(string);
                if (bl && string.equals("method")) {
                    this.setMethodDefaults(string2);
                }
                ((Hashtable)this.m_properties).put(string, string2);
                continue;
            }
            if (!string.equals("cdata-section-elements")) continue;
            ((Hashtable)this.m_properties).put(string, String.valueOf((String)v) + " " + (String)((Hashtable)properties).get(string));
        }
    }

    public void copyFrom(OutputProperties outputProperties) throws TransformerException {
        this.checkDuplicates(outputProperties);
        this.copyFrom(outputProperties.getProperties());
    }

    private static String fixupPropertyString(String string, boolean bl) {
        int n;
        if (bl && string.startsWith(S_XSLT_PREFIX)) {
            string = string.substring(S_XSLT_PREFIX_LEN);
        }
        if (string.startsWith(S_XALAN_PREFIX)) {
            string = S_BUILTIN_EXTENSIONS_UNIVERSAL + string.substring(S_XALAN_PREFIX_LEN);
        }
        if ((n = string.indexOf("\\u003a")) > 0) {
            String string2 = string.substring(n + 6);
            string = String.valueOf(string.substring(0, n)) + ":" + string2;
        }
        return string;
    }

    public boolean getBooleanProperty(String string) {
        return OutputProperties.getBooleanProperty(string, this.m_properties);
    }

    public static boolean getBooleanProperty(String string, Properties properties) {
        String string2 = properties.getProperty(string);
        return string2 != null && string2.equals("yes");
    }

    public boolean getBooleanProperty(QName qName) {
        return this.getBooleanProperty(qName.toNamespacedString());
    }

    public static Properties getDefaultMethodProperties(String string) {
        String string2 = null;
        Properties properties = null;
        try {
            Object object = m_synch_object;
            synchronized (object) {
                if (m_xml_properties == null) {
                    string2 = "output_xml.properties";
                    m_xml_properties = OutputProperties.loadPropertiesFile(string2, null);
                }
            }
            if (string.equals("xml")) {
                properties = m_xml_properties;
            } else if (string.equals("html")) {
                if (m_html_properties == null) {
                    string2 = "output_html.properties";
                    m_html_properties = OutputProperties.loadPropertiesFile(string2, m_xml_properties);
                }
                properties = m_html_properties;
            } else if (string.equals("text")) {
                if (m_text_properties == null && (m_text_properties = OutputProperties.loadPropertiesFile(string2 = "output_text.properties", m_xml_properties)).getProperty("encoding") == null) {
                    object = Encodings.getMimeEncoding(null);
                    ((Hashtable)m_text_properties).put("encoding", object);
                }
                properties = m_text_properties;
            } else {
                properties = m_xml_properties;
            }
        }
        catch (IOException iOException) {
            throw new WrappedRuntimeException("Output method is " + string + " could not load " + string2 + " (check CLASSPATH)", iOException);
        }
        return properties;
    }

    public int getIntProperty(String string) {
        return OutputProperties.getIntProperty(string, this.m_properties);
    }

    public static int getIntProperty(String string, Properties properties) {
        String string2 = properties.getProperty(string);
        if (string2 == null) {
            return 0;
        }
        return Integer.parseInt(string2);
    }

    public int getIntProperty(QName qName) {
        return this.getIntProperty(qName.toNamespacedString());
    }

    public Properties getProperties() {
        return this.m_properties;
    }

    public String getProperty(String string) {
        return this.m_properties.getProperty(string);
    }

    public String getProperty(QName qName) {
        return this.m_properties.getProperty(qName.toNamespacedString());
    }

    public Vector getQNameProperties(String string) {
        return OutputProperties.getQNameProperties(string, this.m_properties);
    }

    public static Vector getQNameProperties(String string, Properties properties) {
        block6: {
            String string2 = properties.getProperty(string);
            if (string2 == null) break block6;
            Vector<QName> vector = new Vector<QName>();
            int n = string2.length();
            boolean bl = false;
            FastStringBuffer fastStringBuffer = new FastStringBuffer();
            int n2 = 0;
            while (n2 < n) {
                block9: {
                    char c;
                    block8: {
                        block7: {
                            c = string2.charAt(n2);
                            if (!Character.isWhitespace(c)) break block7;
                            if (bl) break block8;
                            if (fastStringBuffer.length() > 0) {
                                QName qName = QName.getQNameFromString(fastStringBuffer.toString());
                                vector.addElement(qName);
                                fastStringBuffer.reset();
                            }
                            break block9;
                        }
                        if (c == '{') {
                            bl = true;
                        } else if (c == '}') {
                            bl = false;
                        }
                    }
                    fastStringBuffer.append(c);
                }
                ++n2;
            }
            if (fastStringBuffer.length() > 0) {
                QName qName = QName.getQNameFromString(fastStringBuffer.toString());
                vector.addElement(qName);
                fastStringBuffer.reset();
            }
            return vector;
        }
        return null;
    }

    public Vector getQNameProperties(QName qName) {
        return this.getQNameProperties(qName.toNamespacedString());
    }

    public QName getQNameProperty(String string) {
        return OutputProperties.getQNameProperty(string, this.m_properties);
    }

    public static QName getQNameProperty(String string, Properties properties) {
        String string2 = properties.getProperty(string);
        if (string2 != null) {
            return QName.getQNameFromString(string2);
        }
        return null;
    }

    public QName getQNameProperty(QName qName) {
        return this.getQNameProperty(qName.toNamespacedString());
    }

    public boolean isLegalPropertyKey(String string) {
        return string.equals("cdata-section-elements") || string.equals("doctype-public") || string.equals("doctype-system") || string.equals("encoding") || string.equals("indent") || string.equals("media-type") || string.equals("method") || string.equals("omit-xml-declaration") || string.equals("standalone") || string.equals("version") || string.length() > 0 && string.charAt(0) == '{';
    }

    private static Properties loadPropertiesFile(String string, Properties properties) throws IOException {
        String string2;
        InputStream inputStream;
        Properties properties2;
        block10: {
            properties2 = new Properties(properties);
            inputStream = null;
            BufferedInputStream bufferedInputStream = null;
            try {
                try {
                    inputStream = (class$org$apache$xalan$templates$OutputProperties != null ? class$org$apache$xalan$templates$OutputProperties : (class$org$apache$xalan$templates$OutputProperties = OutputProperties.class$("org.apache.xalan.templates.OutputProperties"))).getResourceAsStream(string);
                    bufferedInputStream = new BufferedInputStream(inputStream);
                    properties2.load(bufferedInputStream);
                }
                catch (IOException iOException) {
                    if (properties == null) {
                        throw iOException;
                    }
                    throw new WrappedRuntimeException("Could not load '" + string + "' (check CLASSPATH) using just the defaults ", iOException);
                }
                string2 = null;
                if (bufferedInputStream == null) break block10;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
                throw throwable;
            }
            bufferedInputStream.close();
        }
        if (inputStream != null) {
            inputStream.close();
        }
        Enumeration enumeration = ((Hashtable)properties2).keys();
        while (enumeration.hasMoreElements()) {
            String string3;
            String string4;
            string2 = (String)enumeration.nextElement();
            String string5 = System.getProperty(string2);
            if (string5 == null) {
                string5 = (String)((Hashtable)properties2).get(string2);
            }
            string4 = (string4 = System.getProperty(string3 = OutputProperties.fixupPropertyString(string2, true))) == null ? OutputProperties.fixupPropertyString(string5, false) : OutputProperties.fixupPropertyString(string4, false);
            if (string2 == string3 && string5 == string4) continue;
            ((Hashtable)properties2).remove(string2);
            ((Hashtable)properties2).put(string3, string4);
        }
        return properties2;
    }

    public void recompose(StylesheetRoot stylesheetRoot) throws TransformerException {
        stylesheetRoot.recomposeOutput(this);
    }

    public void setBooleanProperty(String string, boolean bl) {
        ((Hashtable)this.m_properties).put(string, bl ? "yes" : "no");
    }

    public void setBooleanProperty(QName qName, boolean bl) {
        ((Hashtable)this.m_properties).put(qName.toNamespacedString(), bl ? "yes" : "no");
    }

    public void setIntProperty(String string, int n) {
        ((Hashtable)this.m_properties).put(string, Integer.toString(n));
    }

    public void setIntProperty(QName qName, int n) {
        this.setIntProperty(qName.toNamespacedString(), n);
    }

    public void setMethodDefaults(String string) {
        String string2 = this.m_properties.getProperty("method");
        if (string2 == null || !string2.equals(string)) {
            Properties properties = this.m_properties;
            Properties properties2 = OutputProperties.getDefaultMethodProperties(string);
            this.m_properties = new Properties(properties2);
            this.copyFrom(properties, false);
        }
    }

    public void setProperty(String string, String string2) {
        if (string.equals("method")) {
            this.setMethodDefaults(string2);
        }
        ((Hashtable)this.m_properties).put(string, string2);
    }

    public void setProperty(QName qName, String string) {
        this.setProperty(qName.toNamespacedString(), string);
    }

    public void setQNameProperties(String string, Vector vector) {
        int n = vector.size();
        FastStringBuffer fastStringBuffer = new FastStringBuffer(9, 9);
        int n2 = 0;
        while (n2 < n) {
            QName qName = (QName)vector.elementAt(n2);
            fastStringBuffer.append(qName.toNamespacedString());
            if (n2 < n - 1) {
                fastStringBuffer.append(' ');
            }
            ++n2;
        }
        ((Hashtable)this.m_properties).put(string, fastStringBuffer.toString());
    }

    public void setQNameProperties(QName qName, Vector vector) {
        this.setQNameProperties(qName.toNamespacedString(), vector);
    }

    public void setQNameProperty(String string, QName qName) {
        this.setProperty(string, qName.toNamespacedString());
    }

    public void setQNameProperty(QName qName, QName qName2) {
        this.setQNameProperty(qName.toNamespacedString(), qName2);
    }
}

