/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.cache;

import org.apache.avalon.excalibur.cache.AbstractCache;
import org.apache.avalon.excalibur.cache.CacheStore;
import org.apache.avalon.excalibur.cache.ReplacementPolicy;

public class DefaultCache
extends AbstractCache {
    private ReplacementPolicy m_policy;
    private CacheStore m_store;

    public DefaultCache(ReplacementPolicy policy, CacheStore store) {
        this.m_policy = policy;
        this.m_store = store;
    }

    public int capacity() {
        return this.m_store.capacity();
    }

    public int size() {
        return this.m_store.size();
    }

    public Object put(Object key, Object value) {
        Object oldValue;
        CacheStore cacheStore = this.m_store;
        synchronized (cacheStore) {
            oldValue = this.m_store.containsKey(key) ? this.remove(key) : null;
            if (this.m_store.isFull()) {
                this.remove(this.m_policy.selectVictim());
            }
            this.m_store.put(key, value);
            this.m_policy.add(key);
            this.notifyAdded(key, value);
        }
        return oldValue;
    }

    public Object get(Object key) {
        Object value;
        CacheStore cacheStore = this.m_store;
        synchronized (cacheStore) {
            value = this.m_store.get(key);
            if (this.validate(key, value)) {
                this.m_policy.hit(key);
            } else {
                this.remove(key);
                value = null;
            }
        }
        return value;
    }

    public Object remove(Object key) {
        Object value;
        CacheStore cacheStore = this.m_store;
        synchronized (cacheStore) {
            value = this.m_store.remove(key);
            this.m_policy.remove(key);
            this.notifyRemoved(key, value);
        }
        return value;
    }

    public boolean containsKey(Object key) {
        return null != this.get(key);
    }

    public void clear() {
        CacheStore cacheStore = this.m_store;
        synchronized (cacheStore) {
            Object[] keys = this.m_store.keys();
            int i = 0;
            while (i < keys.length) {
                this.remove(keys[i]);
                ++i;
            }
        }
    }
}

