/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.util;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ConstructorDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.Tag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import org.apache.log4j.Category;
import xdoclet.XDocletException;
import xdoclet.util.Log;
import xdoclet.util.Translator;

public final class DocletUtil {
    static /* synthetic */ Class class$xdoclet$util$DocletUtil;

    public static String getText(Doc doc, String tagName) throws XDocletException {
        return DocletUtil.getText(doc, tagName, true);
    }

    public static String getText(Doc doc, String tagName, boolean superclasses) throws XDocletException {
        Tag[] tags = null;
        if (doc instanceof ClassDoc) {
            tags = DocletUtil.getTagsByName((ClassDoc)doc, tagName, superclasses);
        } else if (doc instanceof MethodDoc) {
            tags = DocletUtil.getTagsByName((MemberDoc)((MethodDoc)doc), tagName);
        } else if (doc instanceof ConstructorDoc) {
            tags = DocletUtil.getTagsByName((MemberDoc)((ConstructorDoc)doc), tagName);
        } else if (doc instanceof FieldDoc) {
            tags = DocletUtil.getTagsByName((MemberDoc)((FieldDoc)doc), tagName);
        } else {
            throw new IllegalArgumentException(Translator.getString("bad_gettext_doc_type", new String[]{doc.toString()}));
        }
        if (tags != null && tags.length > 0) {
            return DocletUtil.getText(tags[0]);
        }
        return null;
    }

    public static String getText(Tag tag) {
        String text = tag.text().trim();
        text = text.replace('\n', ' ');
        return text.replace('\r', ' ');
    }

    public static Tag[] getTagsByName(ClassDoc clazz, String tag_name) {
        return DocletUtil.getTagsByName(clazz, tag_name, true);
    }

    public static Tag[] getTagsByName(ClassDoc clazz, String tag_name, boolean superclasses) {
        Category cat = Log.getCategory(class$xdoclet$util$DocletUtil == null ? (class$xdoclet$util$DocletUtil = DocletUtil.class$("xdoclet.util.DocletUtil")) : class$xdoclet$util$DocletUtil, "getTagsByName");
        if (cat.isDebugEnabled()) {
            cat.debug((Object)("Search for " + tag_name + " in " + clazz + " (look in superclasses=" + superclasses + ")"));
        }
        Tag[] tags = clazz.tags(tag_name);
        String dotted_format_tag_name = tag_name.replace(':', '.');
        if (tags.length == 0) {
            tags = clazz.tags(dotted_format_tag_name);
        }
        if (cat.isDebugEnabled()) {
            cat.debug((Object)(tags.length + " Tags Found"));
        }
        if (superclasses) {
            ArrayList<Tag> tags_list = new ArrayList<Tag>(Arrays.asList(tags));
            boolean found = false;
            clazz = clazz.superclass();
            while (clazz != null) {
                tags = clazz.tags(tag_name);
                if (tags.length == 0) {
                    tags = clazz.tags(dotted_format_tag_name);
                }
                int i = 0;
                while (i < tags.length) {
                    found = false;
                    int j = 0;
                    while (j < tags_list.size()) {
                        if (tags_list.get(j).toString().equals(tags[i].toString())) {
                            found = true;
                            break;
                        }
                        ++j;
                    }
                    if (!found) {
                        tags_list.add(tags[i]);
                    }
                    ++i;
                }
                clazz = clazz.superclass();
            }
            return tags_list.toArray(new Tag[0]);
        }
        return tags;
    }

    public static Tag[] getTagsByName(MemberDoc doc, String tag_name) {
        Tag[] result = doc.tags(tag_name);
        if (result.length == 0) {
            String dotted_format_tag_name = tag_name.replace(':', '.');
            result = doc.tags(dotted_format_tag_name);
        }
        return result;
    }

    public static boolean hasTag(Doc doc, String tag) {
        return DocletUtil.hasTag(doc, tag, true);
    }

    public static boolean hasTag(Doc doc, String tag_name, boolean superclasses) {
        if (DocletUtil.docHasTag(doc, tag_name)) {
            return true;
        }
        if (superclasses) {
            while (doc != null && doc instanceof ClassDoc) {
                if ((doc = ((ClassDoc)doc).superclass()) == null || !DocletUtil.docHasTag(doc, tag_name)) continue;
                return true;
            }
        }
        return false;
    }

    public static String[] tokenizeDelimitedToArray(String delimited, String delimiter) {
        StringTokenizer st = new StringTokenizer(delimited, delimiter);
        String[] ret = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            ret[i++] = st.nextToken();
        }
        return ret;
    }

    private static boolean docHasTag(Doc doc, String tag_name) {
        String dotted_format_tag_name = tag_name.replace(':', '.');
        return doc.tags(tag_name).length > 0 || doc.tags(dotted_format_tag_name).length > 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

