/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.tags;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ConstructorDoc;
import com.sun.javadoc.Type;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.log4j.Category;
import xdoclet.XDocletException;
import xdoclet.XDocletTagSupport;
import xdoclet.tags.AbstractProgramElementTagsHandler;
import xdoclet.tags.TypeTagsHandler;
import xdoclet.util.DocletUtil;
import xdoclet.util.Log;

public class ConstructorTagsHandler
extends AbstractProgramElementTagsHandler {
    static /* synthetic */ Class class$xdoclet$tags$ConstructorTagsHandler;

    protected static boolean hasConstructor(ClassDoc clazz, String constructorName, String[] parameters, boolean setCurrentConstructor) throws XDocletException {
        return AbstractProgramElementTagsHandler.hasExecutableMember(clazz, constructorName, parameters, setCurrentConstructor, 3);
    }

    public void setCurrentConstructor(String template, Properties attributes) throws XDocletException {
        String constructorName = attributes.getProperty("name");
        String parametersStr = attributes.getProperty("parameters");
        String delimiter = attributes.getProperty("delimiter");
        String[] parameters = null;
        if (parametersStr != null) {
            if (delimiter == null) {
                delimiter = ",";
            }
            parameters = DocletUtil.tokenizeDelimitedToArray(parametersStr, delimiter);
        }
        ConstructorDoc oldConstructor = XDocletTagSupport.getCurrentConstructor();
        if (ConstructorTagsHandler.hasConstructor(XDocletTagSupport.getCurrentClass(), constructorName, parameters, true)) {
            this.generate(template);
        }
        XDocletTagSupport.setCurrentConstructor(oldConstructor);
    }

    public String constructorComment(Properties attributes) throws XDocletException {
        return this.memberComment(attributes, 3);
    }

    public String exceptionList(Properties attributes) throws XDocletException {
        return this.exceptionList(attributes, 3);
    }

    public void forAllClassConstructors(String template, Properties attributes) throws XDocletException {
        String type_name = attributes.getProperty("type");
        int extent = TypeTagsHandler.extractExtentType(attributes.getProperty("extent"));
        ClassDoc[] classes = AbstractProgramElementTagsHandler.getAllClasses();
        TreeSet<ConstructorDoc> constructors = new TreeSet<ConstructorDoc>();
        int i = 0;
        while (i < classes.length) {
            if (type_name == null || TypeTagsHandler.isOfType((Type)classes[i], type_name, extent)) {
                ConstructorDoc[] classConstructors = classes[i].constructors();
                int j = 0;
                while (j < classConstructors.length) {
                    constructors.add(classConstructors[j]);
                    ++j;
                }
            }
            ++i;
        }
        Iterator constructorsIterator = constructors.iterator();
        while (constructorsIterator.hasNext()) {
            ConstructorDoc current = (ConstructorDoc)constructorsIterator.next();
            XDocletTagSupport.setCurrentClass(current.containingClass());
            XDocletTagSupport.setCurrentConstructor(current);
            this.generate(template);
        }
    }

    public void forAllConstructors(String template, Properties attributes) throws XDocletException {
        this.forAllMembers(template, attributes, 3);
    }

    public void ifDoesntHaveConstructorTag(String template, Properties attributes) throws XDocletException {
        if (!this.ifHasTag_Impl(template, attributes, 3)) {
            this.generate(template);
        } else {
            String error = attributes.getProperty("error");
            if (error != null) {
                this.getEngine().print(error);
            }
        }
    }

    public void ifHasConstructorTag(String template, Properties attributes) throws XDocletException {
        if (this.ifHasTag_Impl(template, attributes, 3)) {
            this.generate(template);
        } else {
            String error = attributes.getProperty("error");
            if (error != null) {
                this.getEngine().print(error);
            }
        }
    }

    public void executeAndRestoreConstructor(String template, Properties attributes) throws XDocletException {
        ConstructorDoc constructor = XDocletTagSupport.getCurrentConstructor();
        this.generate(template);
        XDocletTagSupport.setCurrentConstructor(constructor);
    }

    public void ifConstructorTagValueEquals(String template, Properties attributes) throws XDocletException {
        if (this.ifTagValueEquals_Impl(template, attributes, 3)) {
            this.generate(template);
        }
    }

    public void ifConstructorTagValueNotEquals(String template, Properties attributes) throws XDocletException {
        if (!this.ifTagValueEquals_Impl(template, attributes, 3)) {
            this.generate(template);
        }
    }

    public String constructorTagValue(Properties attributes) throws XDocletException {
        return this.getTagValue(attributes, 3);
    }

    public void forAllConstructorTags(String template, Properties attributes) throws XDocletException {
        this.forAllMemberTags(template, attributes, 3, "only_call_constructor_not_null", new String[]{"forAllConstructorTags"});
    }

    public void forAllConstructorTagTokens(String template, Properties attributes) throws XDocletException {
        this.forAllMemberTagTokens(template, attributes, 3);
    }

    public String firstSentenceDescriptionOfCurrentConstructor() throws XDocletException {
        return XDocletTagSupport.getCurrentConstructor().firstSentenceTags().length > 0 ? XDocletTagSupport.getCurrentConstructor().firstSentenceTags()[0].text().trim() : "";
    }

    public String constructorName(Properties attributes) throws XDocletException {
        String value;
        if (attributes != null && (value = (String)((Hashtable)attributes).get("value")) != null) {
            String m = XDocletTagSupport.getCurrentConstructor().name().substring(Integer.parseInt(value));
            char firstU = m.charAt(0);
            char firstL = Character.toLowerCase(firstU);
            return firstL + m.substring(1);
        }
        return XDocletTagSupport.getCurrentConstructor() != null ? XDocletTagSupport.getCurrentConstructor().name() : "";
    }

    public String currentConstructorName() throws XDocletException {
        return XDocletTagSupport.getCurrentConstructor().name();
    }

    public void ifHasConstructor(String template, Properties attributes) throws XDocletException {
        this.ifHasConstructor_Impl(template, attributes, true);
    }

    public void ifDoesntHaveConstructor(String template, Properties attributes) throws XDocletException {
        this.ifHasConstructor_Impl(template, attributes, false);
    }

    private void ifHasConstructor_Impl(String template, Properties attributes, boolean has_constructor) throws XDocletException {
        Category cat = Log.getCategory(class$xdoclet$tags$ConstructorTagsHandler == null ? (class$xdoclet$tags$ConstructorTagsHandler = ConstructorTagsHandler.class$("xdoclet.tags.ConstructorTagsHandler")) : class$xdoclet$tags$ConstructorTagsHandler, "ifHasConstructor_Impl");
        String constructorName = attributes.getProperty("name");
        String parametersStr = attributes.getProperty("parameters");
        String delimiter = attributes.getProperty("delimiter");
        String[] parameters = null;
        if (cat.isDebugEnabled()) {
            cat.debug((Object)("constructorName=" + constructorName));
            cat.debug((Object)("parametersStr=" + parametersStr));
            cat.debug((Object)("delimiter=" + delimiter));
            cat.debug((Object)("has_constructor=" + has_constructor));
            cat.debug((Object)("getCurrentClass()=" + XDocletTagSupport.getCurrentClass()));
        }
        if (parametersStr != null) {
            if (delimiter == null) {
                delimiter = ",";
            }
            parameters = DocletUtil.tokenizeDelimitedToArray(parametersStr, delimiter);
            if (cat.isDebugEnabled()) {
                cat.debug((Object)("parameters.length=" + parameters.length));
                cat.debug((Object)("parameters[0]=" + parameters[0]));
            }
        }
        if (ConstructorTagsHandler.hasConstructor(XDocletTagSupport.getCurrentClass(), constructorName, parameters, false) == has_constructor) {
            if (cat.isDebugEnabled()) {
                cat.debug((Object)"constructor found.");
            }
            this.generate(template);
        } else if (cat.isDebugEnabled()) {
            cat.debug((Object)"constructor not found.");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

