/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.ejb;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Tag;
import xdoclet.XDocletException;
import xdoclet.ejb.AbstractEjbCodeGeneratorSubTask;
import xdoclet.ejb.tags.ValueObjectTagsHandler;
import xdoclet.tags.PackageTagsHandler;
import xdoclet.util.DocletUtil;

public class ValueObjectSubTask
extends AbstractEjbCodeGeneratorSubTask {
    public static final String SUBTASK_NAME = "valueobject";
    public static final String DEFAULT_DATAOBJECT_CLASS_PATTERN = "{0}Value";
    protected static String DEFAULT_TEMPLATE_FILE = "/xdoclet/ejb/valueobject.j";
    private static String currentValueObjectClass;
    private static String currentValueObjectName;
    private static String currentValueObjectMatch;
    protected String valueObjectClassPattern;
    protected Tag currentDataObjectTag;

    public ValueObjectSubTask() {
        this.setTemplateURL(this.getClass().getResource(DEFAULT_TEMPLATE_FILE));
        this.setDestinationFile(this.getValueObjectClassPattern() + ".java");
        this.setOfType("javax.ejb.EntityBean");
    }

    public static String getCurrentValueObjectClass() {
        return currentValueObjectClass;
    }

    public static String getCurrentValueObjectName() {
        return currentValueObjectName;
    }

    public static String getCurrentValueObjectMatch() {
        return currentValueObjectMatch;
    }

    public String getSubTaskName() {
        return SUBTASK_NAME;
    }

    public String getValueObjectClassPattern() {
        if (this.valueObjectClassPattern != null) {
            return this.valueObjectClassPattern;
        }
        return DEFAULT_DATAOBJECT_CLASS_PATTERN;
    }

    public void setPattern(String new_pattern) {
        this.valueObjectClassPattern = new_pattern;
    }

    public void validateOptions() throws XDocletException {
        super.validateOptions();
        if (this.getValueObjectClassPattern() == null || this.getValueObjectClassPattern().trim().equals("")) {
            throw new XDocletException("'pattern' parameter missing or empty.");
        }
        if (this.getValueObjectClassPattern().indexOf("{0}") == -1) {
            throw new XDocletException("'pattern' parameter does not have a '{0}' in it. '{0}' is replaced by EJB name of the class under processing.");
        }
    }

    protected String getGeneratedFileName(ClassDoc clazz) throws XDocletException {
        return PackageTagsHandler.packageNameAsPathFor(ValueObjectSubTask.getCurrentValueObjectClass()) + ".java";
    }

    protected boolean matchesGenerationRules(ClassDoc clazz) throws XDocletException {
        if (!super.matchesGenerationRules(clazz)) {
            return false;
        }
        return ValueObjectTagsHandler.isGenerationNeeded(this.getCurrentClass());
    }

    protected void generateForClass(ClassDoc clazz) throws XDocletException {
        Tag[] dos = DocletUtil.getTagsByName(this.getCurrentClass(), "ejb:value-object", false);
        System.out.println("Generating Value Object classes for '" + this.getCurrentClass().qualifiedName() + "'.");
        int i = 0;
        while (i < dos.length) {
            currentValueObjectClass = ValueObjectTagsHandler.getCurrentValueObjectClass(this.getCurrentClass(), dos[i]);
            currentValueObjectName = ValueObjectTagsHandler.getCurrentValueObjectName(this.getCurrentClass(), dos[i]);
            currentValueObjectMatch = ValueObjectTagsHandler.getCurrentValueObjectMatch(this.getCurrentClass(), dos[i]);
            super.generateForClass(clazz);
            ++i;
        }
    }

    protected void engineStarted() throws XDocletException {
        System.out.println("--> " + ValueObjectSubTask.getCurrentValueObjectClass());
    }
}

