/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.template;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;

public class PrettyPrintWriter
extends PrintWriter {
    private boolean prevCharWasNewLine = false;
    private StringBuffer lineBuffer = new StringBuffer();
    private int lineBufferLength;
    public static final String LINE_SEPARATOR = "\n";
    public static final int LINE_SEPARATOR_LEN = "\n".length();

    public PrettyPrintWriter(OutputStream pOut) {
        super(pOut);
    }

    public PrettyPrintWriter(Writer pOut) {
        super(pOut);
    }

    public PrettyPrintWriter(Writer pOut, boolean pAutoFlush) {
        super(pOut, pAutoFlush);
    }

    public void close() {
        if (this.lineBuffer.length() > 0) {
            this.writeLine();
        }
        super.close();
    }

    public void write(char[] pBuffer, int pOffset, int pLength) {
        int i = pOffset;
        while (i < pOffset + pLength) {
            char c = pBuffer[i];
            if (c != '\r') {
                if (c == '\n') {
                    this.lineBuffer.append(LINE_SEPARATOR);
                    this.lineBufferLength += LINE_SEPARATOR_LEN;
                    this.writeLine();
                } else {
                    this.lineBuffer.append(c);
                    ++this.lineBufferLength;
                }
            }
            ++i;
        }
    }

    public void write(int c) {
        if (c != 13) {
            this.lineBuffer.append(c);
            ++this.lineBufferLength;
            if (c == 10) {
                this.writeLine();
            }
        }
    }

    public void write(String pText, int pOffset, int pLength) {
        this.write(pText.toCharArray(), pOffset, pLength);
    }

    public void println() {
        this.write(LINE_SEPARATOR);
    }

    protected void writeLine() {
        boolean all_spaces = true;
        if (this.lineBufferLength == 1 && this.lineBuffer.charAt(0) == '\n') {
            if (!this.prevCharWasNewLine) {
                all_spaces = false;
                this.prevCharWasNewLine = true;
            }
        } else {
            int j = 0;
            while (j < this.lineBufferLength) {
                char temp_char = this.lineBuffer.charAt(j);
                if (!Character.isWhitespace(temp_char)) {
                    this.prevCharWasNewLine = false;
                    all_spaces = false;
                    break;
                }
                ++j;
            }
        }
        if (!all_spaces) {
            char[] line_chars = this.lineBuffer.toString().toCharArray();
            super.write(line_chars, 0, line_chars.length);
        }
        this.lineBuffer = new StringBuffer();
        this.lineBufferLength = 0;
    }
}

